// PSquirtle.cpp: implementation of the PSquirtle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PSquirtle.h"
#include "../PBubbleParticle.h"
#include "../PGame.h"
#include "math.h"
#include "PWaterAttack.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PSquirtle::PSquirtle(PGame* pGame, float x, float y)
{
	this ->pGame = pGame;
	fRunVelocity = fVelocity = 5.0f;
	loc.x = x;
	loc.y = y;
	loc.z = pGame->ground->GetHeight(x, y);
	width = 0.475f;
	height = 0.5f;
	length = 0.25f;
	pVolume.SetCoordinates(loc.x,loc.y,loc.z);
	pVolume.SetDimensions(width, length, height);
	groundBound = true;	
	sModel=new MD2();
	sSkin=new TEXTURE();

	iCharacter = 2;
	iTextureID = 25;
	strcpy(strName, "Squirtle");
	sModel->Load("squirtle.md2");
	sSkin->LoadTGA("squirtle.tga",GL_LINEAR,GL_LINEAR);
	runcount=0;

	pGame->culler->AddToFrustum(this, 0);
}

PSquirtle::~PSquirtle()
{

}

/* draws the squirtle */

void PSquirtle::Draw()
{
	TranslateForDrawing();

	if((aMoves[MC_MOVE_BLOCK] && fAttackEnergy > 0.0f) || pGame ->GetGameState()==GS_GAME_COUNTDOWN) {
		pBall.Draw();
		/*float mat_shield[] = { 0.0f, 0.0f, 1.0f, 0.25f };
		glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_shield);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glutSolidSphere(0.5, 25, 5);
		glDisable(GL_BLEND);*/
	}

	if(!aMoves[MC_MOVE_FORWARD] && !aMoves[MC_MOVE_BACK]) runcount=0;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, sSkin->ID);
	glPushMatrix();
	glScalef(0.025f, 0.025f, 0.025f);
	runcount++;
	RotateForDrawing();
	glRotatef(-90.0,0.0,1.0,0.0);
	glRotatef(-90.0,0.0,0.0,1.0);
	if(runcount==sModel->numFrames) runcount=0;

	if(fFlipRotation || fRollRotation) {
		glTranslatef(0.0, -5.0, 0.0);
		glRotatef(fRollRotation, 0.0, 0.0, 1.0);
		glRotatef(fFlipRotation, 0.0, 1.0, 0.0);
		glRotatef(fFlipRotation * 2.0, 1.0, 0.0, 0.0);
		glTranslatef(0.0, 5.0, 0.0);
	}

	if (shouldDraw) {
		glEnable(GL_LIGHTING);
		glDisable(GL_LIGHT0);

		GLfloat mat_diffuse[] = { .6f, .6, 1.0, 1.0 };
		GLfloat mat_specular[]={.6,.6,1.0,.5};
		GLfloat low_shininess[]={55.0};

		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, low_shininess);

		sModel->Render(runcount);
	}
	glPopMatrix();
	glDisable(GL_TEXTURE_2D);


}

/* determines the attack of the squirtle */

void PSquirtle::Attack(ATTACK_CODE acAttack)
{
	if(aMoves[MC_MOVE_BLOCK] || aMoves[MC_MOVE_FLIP]) return;
	if(acAttack==AC_NORMAL_ATTACK) {
		if(fAttackEnergy - 10.0f < 0.0f) return;
		else fAttackEnergy -= 10.0f;
	} else if(acAttack==AC_CLOSE_ATTACK) {
		if(fAttackEnergy - 20.0f < 0.0f) return;
		else fAttackEnergy -= 20.0f;
	}

	PProjectile * pAttack;
	
	if(acAttack == AC_NORMAL_ATTACK) pAttack = new PWaterAttack(pGame, this);
	else pAttack = new PBubbleParticle(pGame, this, acAttack);

	pAttack ->SetCoordinates(loc.x + 0.5f * pDirection.x, loc.y + 0.5f * pDirection.y, loc.z + 0.5f * pDirection.z);

	PVector dir = pTarget ->GetCoordinates();
	dir.subtract(&loc);
	
	float fAngleSubtended = pDirection2D.angleSubtended(AXIS_Z, & dir);

	if(fAngleSubtended < .523f || fAngleSubtended > 5.76f) {
		dir.makeUnit();
		float fAngle = dir.AngleTo(&pDirection2D);
		dir.Rotate(AXIS_Z, DEGREE(fAngle));
		pAttack ->SetDirection(&dir);
	} else {
		pAttack ->SetDirection(&pDirection2D);
	}

	if(acAttack == AC_NORMAL_ATTACK) ((PWaterAttack *) pAttack) ->MakeWaterParticles();
	pGame ->AddObject(pAttack);
}

/* changes its health according to the damage inflicted */

void PSquirtle::TakeDamage(DAMAGE_TYPE dtType, float fDamage)
{
	if(dtType == DT_LIGHTNING) fDamage *= 1.5f;
	PPokemon::TakeDamage(dtType, fDamage);
	if(pGame->GetGameOption(GO_SOUND)==1) {
		PSound *pSound=pGame->GetSoundObject();
		pSound->PlaySound(SOUND_SQUIRT, false,this->Distance(pGame->GetFocusObject()));
	}
}

void PSquirtle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	//TakeDamage(DT_NORMAL, 25.0);
}

/* gets the squirtle type */

POKEMON_TYPE PSquirtle::GetPokemonType() {
	return PT_SQUIRTLE;
}
