// PPikachuAttack1.cpp: implementation of the PPikachuAttack1 class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GL/glut.h"
#include "PPikachuAttack1.h"
#include "../PPokemon.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


PPikachuAttack1::PPikachuAttack1(PGame * pGame, PDrawableObject * pSource):
	PProjectile(pSource)
{
	fDistance = 1.0f;
	fVelocity = 10.0f;
	this ->pGame = pGame;
	width = 0.75f;
	length = 0.5f;
	height = 0.75f;
	pVolume.SetDimensions(width, length, height);
}

PPikachuAttack1::~PPikachuAttack1()
{

}

void PPikachuAttack1::Draw()
{
	//TranslateForDrawing();
	RotateForDrawing();

	GLfloat mat_diffuse[] = { 1.0f, 0.0f, 0.0f, 1.0f };
	glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
	glutSolidCone(0.05f, 0.5f, 10, 5);
}


void PPikachuAttack1::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(mcMove);
	fDistance += fVelocity * pGame ->GetTimeElapsed();
	if(fDistance > 15.0f) {
		pGame ->RemoveObject(this);
	}
}

void PPikachuAttack1::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	if(pObjectCollidedWith ->GetObjectType() == OBJ_TYPE_POKEMON) {
		PPokemon * pTarget = (PPokemon *) pObjectCollidedWith;
		if(pTarget!=pSource) {
			pTarget ->TakeDamage(DT_NORMAL, 20.0f);
			pGame ->RemoveObject(this);
		}
	}
}
