// PPikachu.cpp: implementation of the PPikachu class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GL/glut.h"
#include "PPikachu.h"
#include "../PLightnParticle.h"
#include "../PGame.h"
#include "math.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////	

PPikachu::PPikachu(PGame* pGame, float x, float y)
{
	this ->pGame = pGame;
	fRunVelocity = fVelocity = 5.0f;
	loc.x = x;
	loc.y = y;
	loc.z = pGame->ground->GetHeight(loc.x, loc.y);
	width = 0.475f;
	height = 0.5f;
	length = 0.25f;
	pVolume.SetCoordinates(loc.x,loc.y,loc.z);
	pVolume.SetDimensions(width, length, height);
	groundBound = true;	
	pModel=new MD2();
	pSkin=new TEXTURE();

	iCharacter = 0;
	iTextureID = 23;
	strcpy(strName, "Pikachu");
	pModel->Load("pikachu.md2");
	pSkin->LoadTGA("pskin.tga",GL_LINEAR,GL_LINEAR);
	runcount=0;

	pGame->culler->AddToFrustum(this, 0);
}

PPikachu::~PPikachu()
{

}

void drawOneLine(float x1, float y1, float z1, float x2, float y2,float z2) {
	glBegin(GL_LINES);
		glVertex3f(x1,y1,z1);
		glVertex3f(x2,y2,z2);
	glEnd();
}

/* draws the pikachu by rendering an image from the model */

void PPikachu::Draw()
{
	TranslateForDrawing();
	
	if((aMoves[MC_MOVE_BLOCK] && fAttackEnergy > 0.0f) || pGame ->GetGameState()==GS_GAME_COUNTDOWN) {	
		pBall.Draw();
		return;
		/*float mat_shield[] = { 1.0f, 1.0f, 0.0f, 0.25f };
		glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_shield);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glutSolidSphere(0.5, 25, 5);
		glDisable(GL_BLEND);*/
	}

	if(!aMoves[MC_MOVE_FORWARD] && !aMoves[MC_MOVE_BACK]) runcount=0;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, pSkin->ID);
	glPushMatrix();
	glScalef(0.03f, 0.03f, 0.03f);
	runcount++;
	if(runcount==pModel->numFrames) runcount=0;
	RotateForDrawing();

	glRotatef(-90.0,0.0,1.0,0.0);
	glRotatef(-90.0,0.0,0.0,1.0);
	
	if(fFlipRotation || fRollRotation) {
		glTranslatef(0.0, -10.0, 0.0);
		glRotatef(fRollRotation, 0.0, 0.0, 1.0);
		glRotatef(fFlipRotation, 0.0, 1.0, 0.0);
		glRotatef(fFlipRotation * 2.0, 1.0, 0.0, 0.0);
		glTranslatef(0.0, 10.0, 0.0);
	}

	if (shouldDraw) {
		glEnable(GL_LIGHTING);
		glDisable(GL_LIGHT0);

		GLfloat mat_diffuse[] = { 1.0f, 1.0, 0.1, 1.0 };
		GLfloat mat_specular[]={1.0,1.0,.5,.5};
		GLfloat low_shininess[]={55.0};

		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, low_shininess);

		pModel->Render(runcount);
	}
	glPopMatrix();
	glDisable(GL_TEXTURE_2D);
}

/* determines what kind of attack and creates a new attack based on that */

void PPikachu::Attack(ATTACK_CODE acAttack)
{
	if(aMoves[MC_MOVE_BLOCK] || aMoves[MC_MOVE_FLIP]) return;
	if(acAttack==AC_NORMAL_ATTACK) {
		if(fAttackEnergy - 10.0f < 0.0f) return;
		else fAttackEnergy -= 10.0f;
	} else if(acAttack==AC_CLOSE_ATTACK) {
		if(fAttackEnergy - 20.0f < 0.0f) return;
		else fAttackEnergy -= 20.0f;
	}

	PLightnParticle * pAttack = new PLightnParticle(pGame, this, acAttack);

	pAttack ->SetCoordinates(loc.x + 0.1f * pDirection.x, loc.y + 0.1f * pDirection.y, loc.z + 0.1f * pDirection.z);

	PVector dir = pTarget ->GetCoordinates();
	dir.subtract(&loc);
	float fAngleSubtended = pDirection2D.angleSubtended(AXIS_Z, & dir);

	if(fAngleSubtended < .523f || fAngleSubtended > 5.76f) {
		dir.makeUnit();
		float fAngle = dir.AngleTo(&pDirection2D);
		dir.Rotate(AXIS_Z, DEGREE(fAngle));
		pAttack ->SetDirection(&dir);
	} else {
		pAttack ->SetDirection(&pDirection2D);
	}

	pGame ->AddObject(pAttack);
}

/* takes a certain amount of damage */

void PPikachu::TakeDamage(DAMAGE_TYPE dtType, float fDamage)
{
	if(dtType == DT_FIRE) fDamage *= 1.5f;
	PPokemon::TakeDamage(dtType, fDamage);
	if(pGame->GetGameOption(GO_SOUND)==1) {
		PSound *pSound=pGame->GetSoundObject();
		pSound->PlaySound(SOUND_PIK, false,this->Distance(pGame->GetFocusObject()));
	}
}

//doesn't really handle collisions-other objects do that

void PPikachu::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	//TakeDamage(DT_NORMAL, 25.0);
}

/* gets the pokemon type */

POKEMON_TYPE PPikachu::GetPokemonType() {
	return PT_PIKACHU;
}