// PPikachu.cpp: implementation of the PPikachu class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GL/glut.h"
#include "PCharmander.h"
#include "../PFireParticle.h"
#include "../PGame.h"
#include "math.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void makeFire(float y, float z);

/* constructor - gets the model from the file, sets location, bounding volume */

PCharmander::PCharmander(PGame* pGame, float x, float y)
{
	this ->pGame = pGame;
	fRunVelocity = fVelocity = 5.0f;
	loc.x = x;
	loc.y = y;
	loc.z = pGame->ground->GetHeight(loc.x, loc.y);
	width = 0.45f;
	height = 0.25f;
	length = 0.15f;
	pVolume.SetCoordinates(loc.x,loc.y,loc.z);
	pVolume.SetDimensions(width, length, height);
	groundBound = true;	
	cModel=new MD2();
	cSkin=new TEXTURE();

	iCharacter = 1;
	iTextureID = 24;
	strcpy(strName, "Charmander");
	cModel->Load("charmander.md2");
	cSkin->LoadTGA("cskin.tga",GL_LINEAR,GL_LINEAR);
	runcount=0;

	pGame->culler->AddToFrustum(this, 0);
}

PCharmander::~PCharmander()
{

}

/* draws the character by rendering a frame from the file */

void PCharmander::Draw()
{
	TranslateForDrawing();

	if((aMoves[MC_MOVE_BLOCK] && fAttackEnergy > 0.0f) || pGame ->GetGameState()==GS_GAME_COUNTDOWN) {
		pBall.Draw();
		return;
		/*float mat_shield[] = { 1.0f, 0.0f, 0.0f, 0.25f };
		glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_shield);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glutSolidSphere(0.5, 25, 5);
		glDisable(GL_BLEND);*/
	}

	if(!aMoves[MC_MOVE_FORWARD] && !aMoves[MC_MOVE_BACK]) runcount=0;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, cSkin->ID);
	glPushMatrix();
	glScalef(0.025f, 0.025f, 0.025f);
	runcount++;
	if(runcount==cModel->numFrames) runcount=0;
	PDrawableObject::RotateForDrawing();
	glTranslatef(-0.2f, 0.0f, 0.0f);
	glRotatef(-90.0,0.0,1.0,0.0);
	glRotatef(-90.0,0.0,0.0,1.0);
	
	if(fFlipRotation || fRollRotation) {
		glRotatef(fRollRotation, 0.0, 0.0, 1.0);
		glRotatef(fFlipRotation, 0.0, 1.0, 0.0);
		glRotatef(fFlipRotation * 2.0, 1.0, 0.0, 0.0);
	}

	if (shouldDraw) {
		glEnable(GL_LIGHTING);
		glDisable(GL_LIGHT0);

		GLfloat mat_diffuse[] = { 1.0f, 1.0, 0.1, 1.0 };
		GLfloat mat_specular[]={1.0,.5,.5,.5};
		GLfloat low_shininess[]={55.0};

		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, low_shininess);

		cModel->Render(runcount);


		glDisable(GL_LIGHTING);
		glDisable(GL_LIGHT0);
	}

	glPopMatrix();
	glDisable(GL_TEXTURE_2D);
}

/* determines which attack to do and "seeks" out the enemy in a limited fashion, 
   as well as update the control panel */

void PCharmander::Attack(ATTACK_CODE acAttack)
{
	if(aMoves[MC_MOVE_BLOCK] || aMoves[MC_MOVE_FLIP]) return;

	if(acAttack==AC_NORMAL_ATTACK) {
		if(fAttackEnergy - 10.0f < 0.0f) return;
		else fAttackEnergy -= 10.0f;
	} else if(acAttack==AC_CLOSE_ATTACK) {
		if(fAttackEnergy - 20.0f < 0.0f) return;
		else fAttackEnergy -= 20.0f;
	}

	PFireParticle * pAttack = new PFireParticle(pGame,this, acAttack);

	pAttack ->SetCoordinates(loc.x, loc.y, loc.z);
	PVector dir = pTarget ->GetCoordinates();
	dir.subtract(&loc);
	
	float fAngleSubtended = pDirection2D.angleSubtended(AXIS_Z, & dir);

	if(fAngleSubtended < .523f || fAngleSubtended > 5.76f) {
		dir.makeUnit();
		float fAngle = dir.AngleTo(&pDirection2D);
		dir.Rotate(AXIS_Z, DEGREE(fAngle));
		pAttack ->SetDirection(&dir);
	} else {
		pAttack ->SetDirection(&pDirection2D);
	}

	pGame ->AddObject(pAttack);
}

/* receives damage from an object */

void PCharmander::TakeDamage(DAMAGE_TYPE dtType, float fDamage)
{
	if(dtType == DT_WATER) fDamage *= 1.5f;
	PPokemon::TakeDamage(dtType, fDamage);
	if(pGame->GetGameOption(GO_SOUND)==1) {
		PSound *pSound=pGame->GetSoundObject();
		pSound->PlaySound(SOUND_CHAR, false,this->Distance(pGame->GetFocusObject()));
	}
}

/* gets the type of pokemon */

POKEMON_TYPE PCharmander::GetPokemonType() {
	return PT_CHARMANDER;
}
