// PWaterParticle.cpp: implementation of the PWaterParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PWaterParticle.h"
#include "PPokemon.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define WATER_PARTS 16

void makeWater(float x, float y, float z);

PWaterParticle::PWaterParticle(PGame *pGame, PDrawableObject *pSource, float x, float y, float z):
	PParticle(pGame,pSource)
{
	pDirection.set(0.0,0.0,0.0);
	lifetime=4.0;
	groundBound=true;
	fDistance = 0.0f;
	fVelocity =2.5f;
	this ->pGame = pGame;
	this->pSource=pSource;
	width = 0.3f;
	length = 0.3f;
	height = 0.3f;
	loc.x=x;
	loc.y=y;
	loc.z=z;
	if(pGame->GetGameOption(GO_SOUND)==1) {
		float dist=this->Distance(pGame->GetFocusObject());
		PSound *pSound=pGame->GetSoundObject();
		pSound->ChangeVolume(SOUND_STREAM,dist);
	}
	pVolume.SetDimensions(width, length, height);
}

PWaterParticle::~PWaterParticle()
{

}

/* draws a water particle */

void PWaterParticle::makeWater(float x, float y, float z) {

	glBegin(GL_POLYGON);
		glTexCoord2f(0,0);
		glVertex3f(x+.08,y,z+.01);
		glTexCoord2f(1,1);
		glVertex3f(x+.06,y+.06,z+.02);
		glVertex3f(x,y+.1,z+.01);
		glTexCoord2f(0,1);
		glVertex3f(x-.06,y+.06,z+.02);
		glVertex3f(x-.08,y,z+.01);
		glTexCoord2f(0,0);
		glVertex3f(x-.06,y-.06,z+.02);
		glVertex3f(x,y-.1,z+.01);
		glTexCoord2f(0,0);
		glVertex3f(x+.06,y-.06,z+.02);
	glEnd();
}

/* draws lots of water particles */

void PWaterParticle::Draw()
{
	glDisable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, textures[43]); 
	glColor3ub(45, 55, 255); 
	glRotatef(ry, 0, 1, 0);
	glRotatef(rx,1,0,0);

	float r,r1;
	for(int i=0;i<WATER_PARTS;i++) {
		r=(float)(rand()%100)/300.0;
		r1=(float)(rand()%100)/300.0;
		if(rand()%2==0) r=-r;
		if(rand()%2==0) r1=-r1;
		makeWater(r,r1,0);
	}

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
}

/* moves the water particles downwards */

void PWaterParticle::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(MC_MOVE_DOWN);
	PVector pt=this->GetCoordinates();
	if((double)(pGame->ground->GetXWidth() - 1) < pt.x ||
		(double)(pGame->ground->GetYLength() - 1) < pt.y || pt.x<0 || pt.y<0)
		pGame->RemoveObject(this);
	//fDistance += fVelocity * fTimeElapsed;
	lifetime-=pGame->GetTimeElapsed();
	if(lifetime < 0.0) {
		pGame ->RemoveObject(this);
	}
}

/* handles the collision between the water and a pokemon */

void PWaterParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	if(pObjectCollidedWith ->GetObjectType() == OBJ_TYPE_POKEMON) {
		PPokemon * pTarget = (PPokemon *) pObjectCollidedWith;
		if(pTarget!=pSource) //pTarget->SetVelocity(pTarget->GetVelocity()-fVelocity);
		{
			float iDamage;
			PVector tVector,cVector;
			float x,y,z;
			x=loc.x+pDirection.getX();
			y=loc.y+pDirection.getY();
			z=pGame->ground->GetHeight(x,y);
			if(x>(float)pGame->ground->GetXWidth()-1) x=(float)pGame->ground->GetXWidth()-1;
			if(x<0) x=0;
			if(y>(float)pGame->ground->GetYLength()-1) y=(float)(float)pGame->ground->GetYLength()-1;
			if(y<0) y=0;

			tVector=PVector(x,y,z);
	
			CPtrArray aCollidingObjects;

			pGame ->DetectCollisions(pTarget, pTarget->GetBoundVolume(), & aCollidingObjects);

			PDrawableObject * pCollidingObject;
			for(int i=0; i<aCollidingObjects.GetSize(); i++) {
				pCollidingObject=(PDrawableObject *) aCollidingObjects.GetAt(i);
				if(pCollidingObject->GetObjectType()==OBJ_TYPE_POKEMON && pCollidingObject!=pTarget) return;
			}
			
			if(pTarget->GetPokemonType()==PT_CHARMANDER) {
				iDamage=.08;
				pTarget->TakeDamage(DT_NORMAL,iDamage);
			}/* else if(pTarget->GetPokemonType()==PT_SQUIRTLE) {
				iDamage=.01;
				pTarget->ChangeEnergy(ET_LIFE,iDamage);
			}*/

			if(loc.z<z)	return;
			pTarget->SetCoordinates(x,y,z);
			pGame->RemoveObject(this);
		}
	}
}
