// PTrackParticle.cpp: implementation of the PTrackParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PTrackParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void makeTrack(float x, float y, float z);

PTrackParticle::PTrackParticle(PGame *pGame, PDrawableObject *pSource):
	PParticle(pGame,pSource)
{

	//fDistance = 1.0f;
	//fVelocity = 5.0f;
	float x,y,z;
	x=pSource->GetCoordinate(AXIS_X);
	y=pSource->GetCoordinate(AXIS_Y);
	z=pGame->ground->GetHeight(x,y);
	this->SetCoordinates(x,y,z);
	lifetime=.6;
	width=height=length=0.0;
	this ->pGame = pGame;
	this->pSource = pSource;
	pVolume.SetDimensions(0, 0, 0);
}

PTrackParticle::~PTrackParticle()
{

}

/* makes a track in the snow */

void PTrackParticle::makeTrack(float x,float y, float z) {
	if(pGame->ground->GetHeight(loc.x,loc.y)>1.0) glColor4f(.3,.3,.5,lifetime);
	else glColor4f(.95,.95,1.0,lifetime);
	glBegin(GL_POLYGON);
		glVertex3f(x+.08,y,z+.01);
		glVertex3f(x+.06,y+.06,z+.02);
		glVertex3f(x,y+.1,z+.01);
		glVertex3f(x-.06,y+.06,z+.02);
		glVertex3f(x-.08,y,z+.01);
		glVertex3f(x-.06,y-.06,z+.02);
		glVertex3f(x,y-.1,z+.01);
		glVertex3f(x+.06,y-.06,z+.02);
	glEnd();
}

/* draws a track particle */

void PTrackParticle::Draw()
{
	glDisable(GL_LIGHTING);
	glDisable(GL_LIGHT0);

	glRotatef(ry,0,1,0);
	glRotatef(rx,1,0,0);
	//glRotatef(rz,0,0,1);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	makeTrack(0,.07,0);
	makeTrack(0,-.07,0);

	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
}

/* lays the track particle on the ground */

void PTrackParticle::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(MC_MOVE_SURROUND);
	lifetime-=pGame->GetTimeElapsed();
	if(lifetime < 0.0 ) {
		pGame ->RemoveObject(this);
	}
}

void PTrackParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	//do nothing, it's just smoke!
}
