// PThread.h: interface for the PThread class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PTHREAD_H__84AFEA8E_E74A_4373_85AD_07F4F51C279F__INCLUDED_)
#define AFX_PTHREAD_H__84AFEA8E_E74A_4373_85AD_07F4F51C279F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PObject.h"
#include "afxmt.h"

class PThread : 
	public PObject, 
	public CWinThread  
{
public:
	/* derived classes must implement Run() and ExitInstance() 
	   Run() is the function executed by the thread
	   ExitInstance() performs cleanup when a thread terminates
	   */

	virtual int Run() = 0;
	virtual int ExitInstance();
	
	virtual BOOL InitInstance();
	void KillThread(int nExitCode, CEvent * pCompletionEvent);
	PThread();
	virtual ~PThread();

protected:
	bool bIsRunning;
	CEvent cTerminationEvent;

};

#endif // !defined(AFX_PTHREAD_H__84AFEA8E_E74A_4373_85AD_07F4F51C279F__INCLUDED_)
