/* PTerrain.h: header for PTerrain class
 */
#ifndef _pterrain_
#define _pterrain_

#include "PDrawableObject.h"
#include "pvector.h"
//#include "PGame.h"
#include "PSkyBox.h"
#include "PMoat.h"

#define INITIAL_LOD 1
#define INITIAL_XWIDTH 32	
#define	INITIAL_YLENGTH 32
#define INITIAL_MAXCHANGE 0.25
#define INITIAL_NUMHILLS 300
#define	INITIAL_MAXHEIGHT 3
#define INITIAL_MINRADIUS 1
#define	INITIAL_MAXRADIUS 5
#define	INITIAL_SKYWIDTH 80
#define INITIAL_SKYLENGTH 80
#define __ARB_ENABLE true							// Used To Disable ARB Extensions Entirely
// #define EXT_INFO								// Uncomment To See Your Extensions At Start-Up?
#define MAX_EXTENSION_SPACE 10240						// Characters For Extension-Strings
#define MAX_EXTENSION_LENGTH 256						// Maximum Characters In One Extension-String

class PGame;

class PTerrain : public PDrawableObject  
{
public:
	PVector GetWind();
	PTerrain(PGame* pGame);
//	PTerrain(int xWidth, int yLength, int LOD, float maxChange, PGame* pGame);
	~PTerrain();
	void GenerateMap(int xWidth, int yLength, int LOD, float maxChange,
				     float maxHeight, int numHills, float minRadius, 
					float maxRadius, int skyBox);
	void GenerateMap();
	void Draw (void);
	float GetHeight(float x, float y);
	void SetHeight(float x, float y, float height);
	void ChangeHeight(float x, float y, float heightChange);
	void SetLOD (int LOD);
	void SetXWidth (int xWidth);
	void SetYLength (int yLength);
	void SetMaxChange (float maxChange);
	int GetLOD (void);
	int GetXWidth(void);
	int GetYLength(void);
	float GetMaxChange(void);
	float GetMaxHeight(void);
	void FreeMap (void);
	void AllocateMap (void);
	void SetMap (int xWidth, int yLength, int LOD, float maxChange, 
				 float maxHeight, int numHills, float minRadius, float maxRadius,
				 int skyBox);
	PVector GetNormal (float x, float y);
	//void LoadMap(FILE* filename);
	//SaveMap
	bool** mapDraw;
	bool** moatDraw;
	PSkyBox *skyBox;
	PMoat *moat;
	bool** moatLand;
	float **map;

protected:
	PGame *pGame;
	int LOD, xWidth, yLength, numHills;
	float maxHeight, minRadius, maxRadius;
	float maxChange, prevHeight; //Maximum heightChange between adjacent points
	bool multitextureSupported;
	PVector wind;
};
#endif