// PTerrain.cpp: implementation of the PTerrain class.
//
//////////////////////////////////////////////////////////////////////

#include "math.h"
#include "stdafx.h"
#include "PTerrain.h"
#include <gl\gl.h>			// Header File For The OpenGL32 Library
#include "PGame.h"
#include "PWaterParticle.h"
#include "glext.h"
#include "PSnowParticle.h"
#include "PLavaParticle.h"
#include "PFlameFountain.h"
#include "PRainParticle.h"

bool multitextureSupported=false;						// Flag Indicating Whether Multitexturing Is Supported
bool useMultitexture=true;							// Use It If It Is Supported?
GLint maxTexelUnits=1;								// Number Of Texel-Pipelines. This Is At Least 1.

PFNGLMULTITEXCOORD1FARBPROC	glMultiTexCoord1fARB	= NULL;
PFNGLMULTITEXCOORD2FARBPROC	glMultiTexCoord2fARB	= NULL;
PFNGLMULTITEXCOORD3FARBPROC	glMultiTexCoord3fARB	= NULL;
PFNGLMULTITEXCOORD4FARBPROC	glMultiTexCoord4fARB	= NULL;
PFNGLACTIVETEXTUREARBPROC	glActiveTextureARB	= NULL;
PFNGLCLIENTACTIVETEXTUREARBPROC	glClientActiveTextureARB= NULL;

bool isInString(char *string, const char *search);
bool initMultitexture();

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/*PTerrain::PTerrain(int xWidth, int yLength, int LOD, float maxChange, PGame* pGame)
{
	this->pGame = pGame;
	SetMap(xWidth, yLength, LOD, maxChange);
	AllocateMap();
	GenerateMap();
}
*/

/* PTerrain Constructor
 * --------------------
 * Constructor for PTerrain.  Initializes various variables and the map.  Also submits it
 * to the frustum culler.
 */
PTerrain::PTerrain(PGame* pGame)
{
	this->pGame = pGame;
	SetMap(INITIAL_XWIDTH, INITIAL_YLENGTH, INITIAL_LOD, INITIAL_MAXCHANGE,
			INITIAL_MAXHEIGHT, INITIAL_NUMHILLS, INITIAL_MINRADIUS, 
			INITIAL_MAXRADIUS, INITIAL_SKYWIDTH);
	moat = new PMoat(pGame, xWidth, yLength, INITIAL_SKYWIDTH, INITIAL_SKYLENGTH);
	AllocateMap();
	GenerateMap();
	pGame->culler->AddToFrustum(this, 1);

	wind=PVector((float)(rand()%20)*.1,(float)(rand()%20)*.1,0);
//	multitextureSupported=initMultitexture();

/*	this->xWidth = INITIAL_XWIDTH;
	this->yLength = INITIAL_YLENGTH;
	this->LOD = INITIAL_LOD;
	this->maxChange = INITIAL_MAXCHANGE;
	GenerateMap();
	*/
}

/* PTerrain Destructor
 * -------------------
 * Destructor for PTerrain.  Initializes various variables and the map.  Frees map.
 */
PTerrain::~PTerrain()
{
	FreeMap();
}


/* GenerateMap
 * ------------------
 * Generates map.  Initializes field to 0 height.  Adds hills of various heights throughout
 * the field and normalizes the values so that no height is greater than a maximum height.
 * Then it adds 0.1 to all land within a circle on the terrain.
 */
void PTerrain::GenerateMap(int xWidth, int yLength, int LOD, float maxChange,
						   				 float maxHeight, int numHills, 
										 float minRadius, float maxRadius,
										 int skyBox)
{
	//Add LOD and maxChange usage later
	int i, j, k;
	float max = 0, min = maxHeight * numHills, multiplier;
	float xSquared, ySquared, rSquared;
//	float temp;
	
	if (xWidth <= yLength) {
		rSquared = pow(((float)xWidth)/2 - 1, 2);
	}
	else {
		rSquared = pow(((float)yLength)/2 - 1, 2);
	}

	if (xWidth != this->xWidth || yLength != this->yLength) {
		FreeMap();
		SetMap(xWidth, yLength, LOD, maxChange, maxHeight, numHills, minRadius,
				maxRadius, skyBox);
		AllocateMap();
	}

	//srand((int)((((float)((int)map) * (float)LOD)) / 
	//		((float)(xWidth * yLength * 2))));
	
	for (i = 0; i < xWidth; i++) {
		for (j = 0; j < yLength; j++) {
			map[i][j] = 0.0;
			moatLand[i][j] = false;
		}
	}

	for (k = 0; k < numHills; k++) {
		float maxRad = maxRadius;
		float minRad = minRadius;
		float xCenter = ((float)rand())/((float)RAND_MAX) * (float)(xWidth - 7) + 3;
		float yCenter = ((float)rand())/((float)RAND_MAX) * (float)(yLength - 7) + 3;
		if (xCenter + maxRad >= (float)(xWidth - 4)) {
			maxRad = xWidth - 4 - xCenter;
		}
		if (xCenter - maxRad <= 3) {
			maxRad = xCenter - 3;
		}
		if (yCenter + maxRad >= (float)(yLength - 4)) {
			maxRad = yLength - 4 - yCenter;
		}
		if (yCenter - maxRad <= 3) {
			maxRad = yCenter - 3;
		}
		if (maxRad * (minRadius / maxRadius) <= minRad) {
			minRad = maxRad * (minRadius / maxRadius);
		}
		float radius = (((float)rand())/((float)RAND_MAX) * (float)(maxRad - minRad))
						+ minRad;
		for (i = (int)(ceil(xCenter - radius)); 
			 i < (int)(floor(xCenter + radius)); i++) {
			if (i >= 0 && i < xWidth) {
				for (j = (int)(ceil(yCenter - radius)); 
				     j < (int)(floor(yCenter + radius)); j++) {
					if (j >= 0 && j < yLength) {
						float temp = (pow(radius,2)) - 
									 (pow(((float)i-xCenter),2) +
									  pow(((float)j-yCenter),2));
						if (temp > 0) {
							map[i][j] = map[i][j] + temp;
						}
					}
				}
			}
		}
	}

	for (i = 0; i < xWidth; i++) {
		for (j = 0; j < yLength; j++) {
			if (map[i][j] > max) {
				max = map[i][j];
			}
			if (map[i][j] < min) {
				min = map[i][j];
			}
		}
	}

	if (max > maxHeight) {
		multiplier = maxHeight;
	}
	else {
		multiplier = max;
	}

	for (i = 0; i < xWidth; i++) {
		for (j = 0; j < yLength; j++) {
			map[i][j] = (map[i][j] - min)/(max - min);
			map[i][j] = pow(map[i][j],2);
			map[i][j] = (map[i][j] * multiplier);
		}
	}

	for (i = 0; i < xWidth; i++) {
		for (j = 0; j < yLength; j++) {
			xSquared = pow(fabs(i - ((float)(xWidth))/2), 2);
			ySquared = pow(fabs(j - ((float)(yLength))/2), 2);
			map[i][j] = map[i][j] + 0.1;
			if (xSquared + ySquared >= rSquared) {
				map[i][j] = 0;
				if (map[i][j] < 0.1) {
					moatLand[i][j] = true;
				}
			}
		}
	}
/*	for (j = 0; j < yLength; j++) {
		map[0][j] = 0;
		map[xWidth-1][j] = 0;
	}

	for (i = 1; i < xWidth - 1; i++) {
		map[i][0] = 0;
		map[i][yLength-1] = 0;
		for (j = 1; j < yLength - 1; j++) {
			temp = (((float)rand()) / ((float)RAND_MAX));
			if (map[i-1][j] > 2) {
				if (temp > 0.90) {
					temp = 2.5*(temp - 0.8) + map[i-1][j];
				}
				else if (temp < 0.40) {
					temp = (temp - 0.40) * 0.625 + map[i-1][j];
				}
				else if (temp < 0.65) {
					temp = map[i][j-1];
				}
				else {
					temp = map[i-1][j];
				}
			}
			else if (map[i-1][j] < 2) {
				if (temp > 0.60) {
					temp = 0.625 * (temp - 0.60) + map[i-1][j];
				}
				else if (temp < 0.10) {
					temp = (temp - 0.10)*2.5 + map[i-1][j];
				}
				else if (temp < 0.35) {
					temp = map[i][j-1];
				}
				else {
					temp = map[i-1][j];
				}
			}
			else {
				if (temp > 0.75) {
					temp = temp - 0.75 + map[i-1][j];
				}
				else if (temp < 0.25) {
					temp = temp - 0.25 + map[i-1][j];
				}
				else if (temp < 0.50) {
					temp = map[i][j-1];
				}
				else {
					temp = map[i-1][j];
				}
			}
			if (temp < map[i][j-1] - 0.25) {
				temp = map[i][j-1] - 0.25;
			}
			else if (temp > map[i][j-1] + 0.25) {
				temp = map[i][j-1] + 0.25;
			}
			map[i][j] = temp;
		}
	}*/
}

/* GenerateMap
 * ------------------
 * Calls the other GenerateMap with given parameters.
 */
void PTerrain::GenerateMap()
{
	GenerateMap (xWidth, yLength, LOD, maxChange, maxHeight, numHills,
				 minRadius, maxRadius, skyBox->GetSkyWidth());
}

/* Draw
 * ------------------
 * Iterates through the terrain map by row and column and draws it out.  Draws SkyBox and
 * Moat as well.
 */
void PTerrain::Draw (void)
{
	//adjust for LOD
	int i, j;
	float LOD = (float)(this->LOD);

	//glColor4f(0.0,.8,0.2,1.0);
	
	glEnable(GL_TEXTURE_2D);
	moat->Draw();
	if(pGame->GetStage()!=1) skyBox->Draw();
	if(pGame->GetStage()==1) glEnable(GL_FOG);
	else glDisable(GL_FOG);

	GLfloat mat_diffuse[] = { 1.0f, 1.0f, 1.0f, 1.0f };

	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	//glEnable(GL_BLEND);
	//glDisable(GL_BLEND);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	float r;
	int water=0,lava=0;
	for (i = 0; i < xWidth-1; i++) {
		for (j = 0; j < yLength-1; j++) {

			if(map[i][j]>2.0 && water<2 && pGame->GetStage()==0) {
				water++;
				PWaterParticle *pWater=new PWaterParticle(pGame, this, i, j, map[i][j]);
				//pWater ->SetCoordinates(i , j , map[i][j]);
				//pWater ->Rotate(AXIS_Z, rz);
				pGame ->AddObject(pWater);
			}

			r=(float)(rand()%200);
			if(pGame->GetStage()==1) {
				glFogi(GL_FOG_MODE, GL_LINEAR);
				glFogi(GL_FOG_INDEX, 32);
				glFogf(GL_FOG_START,15.0);
				glFogf(GL_FOG_END,30.0);
				glHint(GL_FOG_HINT, GL_NICEST);

				if(r==0.0) {
					PSnowParticle *pSnow=new PSnowParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pSnow);
				}
			}

			if(pGame->GetStage()==2 && map[i][j]>2.0 && lava<2) {
				lava++;
				//lava flow!

				PLavaParticle *pLava=new PLavaParticle(pGame, this, i, j, map[i][j]);
				//pWater ->SetCoordinates(i , j , map[i][j]);
				//pWater ->Rotate(AXIS_Z, rz);
				pGame ->AddObject(pLava);
			}
			if(pGame->GetStage()==2 && map[i][j]>2.0 && lava>=2 && lava <4) {
				lava++;
				PFlameFountain * pFountain;
				PVector dir;
				for (int k=0;k<6;k++) {
					pFountain = new PFlameFountain(pGame, this);
					pFountain ->SetCoordinates(i, j, map[i][j] + 0.5f);
					dir.x=(float)(rand()%20)/100.0;
					dir.y=(float)(rand()%20)/100.0;
					if(i < 3) {
						dir.Rotate(AXIS_Z, 45 + rand() % 45);
					} else {
						dir.Rotate(AXIS_Z, -(45 + rand() % 45));
					}
					dir.z = 0.5f + rand() % 10 * 0.1f;
					pFountain ->SetDirection(&dir);
					pGame ->AddObject(pFountain);
				}
			}
			r=(float)(rand()%20);
			if(pGame->GetStage()==3 && r==0.0) {
				PRainParticle *pRain=new PRainParticle(pGame, this, i, j, 8.0);
				pGame->AddObject(pRain);
			}
			/*if(pGame->GetStage()==2 && map[i][j]>2.0) {
				PFlameParticle *pFlame=new PFlameParticle(pGame,this, i, j, map[i][j]+.1);
				pGame->AddObject(pFlame);
			}*/

/*			glActiveTextureARB(GL_TEXTURE0_ARB);*/

			if (mapDraw[i][j]) {
				glEnable(GL_TEXTURE_2D);
				if(pGame->GetStage()==0) {
					glBindTexture(GL_TEXTURE_2D, textures[28]);
					glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
					if(map[i][j]<=.3) {
						glBindTexture(GL_TEXTURE_2D, textures[38]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]<=.6 && map[i][j]>.3) {
						glBindTexture(GL_TEXTURE_2D, textures[37]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>.6 && map[i][j]<=1.0) {
						glBindTexture(GL_TEXTURE_2D, textures[35]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>1.0 && map[i][j]<=1.6) {
						glBindTexture(GL_TEXTURE_2D, textures[35]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>1.6) {
						glBindTexture(GL_TEXTURE_2D, textures[33]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					}
				} else if(pGame->GetStage()==1) {
					glBindTexture(GL_TEXTURE_2D, textures[28]);
					glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
					if(map[i][j]<=.3) {
						glBindTexture(GL_TEXTURE_2D, textures[30]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]<=.6 && map[i][j]>.3) {
						glBindTexture(GL_TEXTURE_2D, textures[39]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>.6 && map[i][j]<=1.0) {
						glBindTexture(GL_TEXTURE_2D, textures[40]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>1.0 && map[i][j]<=1.6) {
						glBindTexture(GL_TEXTURE_2D, textures[41]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>1.6) {
						glBindTexture(GL_TEXTURE_2D, textures[42]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					}
				} else if(pGame->GetStage()==2) {
					glBindTexture(GL_TEXTURE_2D, textures[28]);
					glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
					if(map[i][j]<=.3) {
						glBindTexture(GL_TEXTURE_2D, textures[48]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]<=.6 && map[i][j]>.3) {
						glBindTexture(GL_TEXTURE_2D, textures[51]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>.6 && map[i][j]<=1.0) {
						glBindTexture(GL_TEXTURE_2D, textures[52]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>1.0 && map[i][j]<=1.6) {
						glBindTexture(GL_TEXTURE_2D, textures[53]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>1.6) {
						glBindTexture(GL_TEXTURE_2D, textures[54]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					}
				} else if(pGame->GetStage()==3) {
					glBindTexture(GL_TEXTURE_2D, textures[28]);
					glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
					if(map[i][j]<=.3) {
						glBindTexture(GL_TEXTURE_2D, textures[57]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]<=.6 && map[i][j]>.3) {
						glBindTexture(GL_TEXTURE_2D, textures[58]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>.6 && map[i][j]<=1.0) {
						glBindTexture(GL_TEXTURE_2D, textures[59]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>1.0 && map[i][j]<=1.6) {
						glBindTexture(GL_TEXTURE_2D, textures[60]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					} else if(map[i][j]>1.6) {
						glBindTexture(GL_TEXTURE_2D, textures[61]);
						glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
					}
				}

				
/*				glBegin(GL_TRIANGLES);
					glTexCoord2f(0.0f,0.0f);
					glVertex3f(((float)i)/LOD,((float)(-j))/(-LOD),(map[i][j]/LOD));
					glTexCoord2f(1.0f,0.0f);
					glVertex3f(((float)(i+1))/LOD,((float)(-j))/(-LOD),(map[i+1][j]/LOD));
					glTexCoord2f(0.0f,1.0f);
					glVertex3f(((float)(i))/LOD,((float)(-(j+1)))/(-LOD),(map[i][j+1]/LOD));
					glTexCoord2f(1.0f,1.0f);
					glVertex3f(((float)(i+1))/LOD,((float)(-(j+1)))/(-LOD),(map[i+1][j+1]/LOD));
					glTexCoord2f(0.0f,1.0f);
					glVertex3f(((float)i)/LOD,((float)(-(j+1)))/(-LOD),(map[i][j+1]/LOD));
					glTexCoord2f(1.0f,0.0f);
					glVertex3f(((float)(i+1))/LOD,((float)(-j))/(-LOD),(map[i+1][j]/LOD));
				glEnd();*/

			
				bool drawn = false;

				if (!(moatLand[i][j] || moatLand[i][j+1] || moatLand[i+1][j])) {
					drawn = true;
					glBegin(GL_TRIANGLES);
							glTexCoord2f(0.0f,0.0f);
							glVertex3f(((float)i)/LOD,((float)(-j))/(-LOD),(map[i][j]));
							glTexCoord2f(1.0f,0.0f);
							glVertex3f(((float)(i+1))/LOD,((float)(-j))/(-LOD),(map[i+1][j]));
							glTexCoord2f(0.0f,1.0f);
							glVertex3f(((float)(i))/LOD,((float)(-(j+1)))/(-LOD),(map[i][j+1]));
					glEnd();
				}

				if (!(moatLand[i+1][j+1] || moatLand[i][j+1] || moatLand[i+1][j])) {
					drawn = true;
					glBegin(GL_TRIANGLES);
							glTexCoord2f(1.0f,1.0f);
							glVertex3f(((float)(i+1))/LOD,((float)(-(j+1)))/(-LOD),(map[i+1][j+1]));
							glTexCoord2f(0.0f,1.0f);
							glVertex3f(((float)i)/LOD,((float)(-(j+1)))/(-LOD),(map[i][j+1]));
							glTexCoord2f(1.0f,0.0f);
							glVertex3f(((float)(i+1))/LOD,((float)(-j))/(-LOD),(map[i+1][j]));
					glEnd();
				}

				if (!drawn) {
					if (pGame->ground->map[i][j+1] < 0.1 &&
						pGame->ground->map[i+1][j] >= 0.1) {
						glBegin(GL_TRIANGLES);
							glTexCoord2f(1.0f,0.0f);
							glVertex3f(((float)(i+1))/LOD,((float)(-(j)))/(-LOD),(map[i+1][j]));
							glTexCoord2f(1.0f,1.0f);
							glVertex3f(((float)(i+1))/LOD,((float)(-(j+1)))/(-LOD),(map[i+1][j+1]));								
							glTexCoord2f(0.0f,0.0f);
							glVertex3f(((float)(i))/LOD,((float)(-j))/(-LOD),(map[i][j]));
						glEnd();
					}
					else if (pGame->ground->map[i+1][j] < 0.1 &&
						pGame->ground->map[i][j+1] >= 0.1) {
						glBegin(GL_TRIANGLES);
							glTexCoord2f(0.0f,1.0f);
							glVertex3f(((float)(i))/LOD,((float)(-(j+1)))/(-LOD),(map[i][j+1]));
							glTexCoord2f(0.0f,0.0f);
							glVertex3f(((float)i)/LOD,((float)(-(j)))/(-LOD),(map[i][j]));
							glTexCoord2f(1.0f,1.0f);
							glVertex3f(((float)(i+1))/LOD,((float)(-(j+1)))/(-LOD),(map[i+1][j+1]));
						glEnd();					
					}
				}
			}
		}
	}
	//glPopAttrib();
	//glDisable(GL_BLEND);
	glDisable(GL_TEXTURE_2D);
	//glEnable(GL_BLEND);
}

/* GetHeight
 * ------------------
 * Returns the height at the passed-in values of x and y.  Interpolates linearly
 * between points in the height map.
 */
float PTerrain::GetHeight(float x, float y)
{
	//adjust for LOD
	x = (x) * (float)LOD;
	y = (y) * (float)LOD;
	if (x >= 0 && x < (float)(xWidth-1) && y >= 0 && y < (float)(yLength-1)) {
		if (floor(x) == ceil(x) && floor(y) == ceil(y)) {
			return (map[(int)ceil(x)][(int)ceil(y)]);
		}
		else {
			float lowerX1 = map[(int)floor(x)][(int)floor(y)];
			float lowerX2 = map[(int)floor(x)][(int)ceil(y)];
			float upperX1 = map[(int)ceil(x)][(int)floor(y)];
			float upperX2 = map[(int)ceil(x)][(int)ceil(y)];
			float lowerX = ((y - (float)(floor(y))) * lowerX2) + 
							(((float)(ceil(y)) - y) * lowerX1);
			float upperX = ((y - (float)(floor(y))) * upperX2) + 
							(((float)(ceil(y)) - y) * upperX1);
			if (floor(x) == ceil(x)) {
				return (upperX);
			}
			else if (floor(y) == ceil(y)) {
				float height = ((x - (float)(floor(x))) * upperX1) +
								(((float)(ceil(x)) - x) * lowerX1);
				return (height);
			}
			else {
				float height = ((x - (float)(floor(x))) * upperX) + 
								(((float)(ceil(x)) - x) * lowerX);
				return(height);
			}
		}
	}
	else {
		return (0); //error
	}
}


/* SetHeight
 * ------------------
 * Sets the height of a point on the point map.
 */
void PTerrain::SetHeight(float x, float y, float height)
{
	//add toggle for group terrain setting and adjust for LOD
	x = x * (float)LOD;
	y = y * (float)LOD;
	if (x - (float)(floor(x)) > 0.5) {
		x = (float)(ceil(x));
	}
	else {
		x = (float)(floor(x));
	}
	if (y - (float)(floor(y)) > 0.5) {
		y = (float)(ceil(y));
	}
	else {
		y = (float)(floor(y));
	}
	if (x >= 0 && x < (float)xWidth && y >= 0 && y < (float)yLength) {
		map[(int)x][(int)y] = height;
	}
}

/* ChangeHeight
 * ------------------
 * Changes the height of point on the height map by a delta value.
 */
void PTerrain::ChangeHeight(float x, float y, float heightChange)
{
	//add toggle for group terrain setting and adjust for LOD
	x = x * (float)LOD;
	y = y * (float)LOD;
	if (x - (float)(floor(x)) > 0.5) {
		x = (float)(ceil(x));
	}
	else {
		x = (float)(floor(x));
	}
	if (y - (float)(floor(y)) > 0.5) {
		y = (float)(ceil(y));
	}
	else {
		y = (float)(floor(y));
	}
	if (x >= 0 && x < (float)xWidth && y >= 0 && y < (float)yLength) {
		map[(int)x][(int)y] = map[(int)x][(int)y] + heightChange;
	}
}


/* Set(Variable)
 * ------------------
 * Sets the values of LOD, xWidth, yLength, or maxChange.
 */
void PTerrain::SetLOD (int LOD)
{
	this->LOD = LOD;
}

void PTerrain::SetXWidth (int xWidth)
{
	this->xWidth = xWidth;
}

void PTerrain::SetYLength (int yLength)
{
	this->yLength = yLength;
}

void PTerrain::SetMaxChange (float maxChange)
{
	this->maxChange = maxChange;
}

/* Get(Variable)
 * ------------------
 * Returns the value of LOD, xWidth, yLength, maxChange, or maxHeight.
 */
int PTerrain::GetLOD (void)
{
	return (LOD);
}

int PTerrain::GetXWidth(void)
{
	return (xWidth);
}

int PTerrain::GetYLength(void)
{
	return (yLength);
}

float PTerrain::GetMaxChange(void)
{
	return (maxChange);
}

float PTerrain::GetMaxHeight(void)
{
	return (maxHeight);
}

/* FreeMap
 * ------------------
 * Frees the map.
 */
void PTerrain::FreeMap (void)
{
	int i;
	if (map != NULL) {
		for (i = 0; i < xWidth; i++) {
			if (map[i] != NULL) {
				free(map[i]);
			}
		}
		free (map);
	}
}

/* AllocateMap
 * ------------------
 * Allocates the memory for the various grids for the map.
 */
void PTerrain::AllocateMap (void)
{
	int i;
	map = (float**)malloc(sizeof(float*) * xWidth);
	for (i = 0; i < xWidth; i++) {
		map[i] = (float *)malloc(sizeof(float) * yLength);
	}
	mapDraw = (bool**)malloc(sizeof(bool*) * (xWidth - 1));
	for (i = 0; i < xWidth - 1; i++) {
		mapDraw[i] = (bool *)malloc(sizeof(bool) * (yLength - 1));
	}
	moatLand = (bool**)malloc(sizeof(bool*) * xWidth);
	for (i = 0; i < xWidth; i++) {
		moatLand[i] = (bool *)malloc(sizeof(bool) * yLength);
	}
	moatDraw = (bool**)malloc(sizeof(bool*) * (skyBox->GetSkyWidth() + 1));
	for (i = 0; i < skyBox->GetSkyWidth() + 1; i++) {
		moatDraw[i] = (bool *)malloc(sizeof(bool) * (skyBox->GetSkyLength() + 1));
	}
}

/* SetMap
 * ------------------
 * Sets the variable values for the map.
 */
void PTerrain::SetMap (int xWidth, int yLength, int LOD, float maxChange,
					   float maxHeight, int numHills, float minRadius, 
					   float maxRadius, int skyBox)
{
	this->xWidth = xWidth;
	this->yLength = yLength;
	this->LOD = LOD;
	this->maxChange = maxChange;
	this->maxHeight = maxHeight;
	this->numHills = numHills;
	this->minRadius = minRadius;
	this->maxRadius = maxRadius;
	this->skyBox = new PSkyBox(pGame, xWidth, yLength, skyBox, skyBox, skyBox);
}

/* GetNormal
 * ------------------
 * Returns the normal value at a given x and y coordinate.
 * 
 */
PVector PTerrain::GetNormal (float x, float y)
{
	if (x < 0 || x > (float)(xWidth-2) || y < 0 || y > (float)(yLength-2)) {
		return PVector(0.0, 0.0, 1.0);
	}

		
	
	PVector vector1, vector2;
	x = x * (float)LOD;
	y = y * (float)LOD;
	if (x - floor(x) + y - floor(y) < 1) {
		vector1 = PVector(1, 0, map[(int)(floor(x) + 1)][(int)(floor(y))] - 
					      map[(int)(floor(x))][(int)(floor(y))]);
		vector2 = PVector(0, 1, map[(int)(floor(x))][(int)(floor(y) + 1)] - 
					      map[(int)(floor(x))][(int)(floor(y))]);
	}
	else {
		vector1 = PVector(-1, 0, map[(int)(floor(x))][(int)(floor(y) + 1)] - 
					      map[(int)(floor(x) + 1)][(int)(floor(y) + 1)]);
		vector2 = PVector(0, -1, map[(int)(floor(x) + 1)][(int)(floor(y))] - 
					      map[(int)(floor(x) + 1)][(int)(floor(y) + 1)]);		
	}
	
	return vector1.cross(& vector2);
}

bool isInString(char *string, const char *search) {
	int pos=0;
	int maxpos=strlen(search)-1;
	int len=strlen(string);
	char *other;
	for (int i=0; i<len; i++) {
		if ((i==0) || ((i>1) && string[i-1]=='\n')) {			// New Extension Begins Here!
			other=&string[i];
			pos=0;							// Begin New Search
			while (string[i]!='\n') {				// Search Whole Extension-String
				if (string[i]==search[pos]) pos++;		// Next Position
				if ((pos>maxpos) && string[i+1]=='\n') return true;	// We Have A Winner!
				i++;
			}
		}
	}
	return false;								// Sorry, Not Found!
}

bool initMultitexture(void) {
	char *extensions;
	extensions=strdup((char *) glGetString(GL_EXTENSIONS));			// Fetch Extension String
	int len=strlen(extensions);
	for (int i=0; i<len; i++)						// Separate It By Newline Instead Of Blank
		if (extensions[i]==' ') extensions[i]='\n';

#ifdef EXT_INFO
	MessageBox(hWnd,extensions,"supported GL extensions",MB_OK | MB_ICONINFORMATION);
#endif

	if (isInString(extensions,"GL_ARB_multitexture")			// Is Multitexturing Supported?
		&& __ARB_ENABLE							// Override Flag
		&& isInString(extensions,"GL_EXT_texture_env_combine"))		// texture-environment-combining supported?
	{       
		glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB,&maxTexelUnits);
		glMultiTexCoord1fARB = (PFNGLMULTITEXCOORD1FARBPROC) wglGetProcAddress("glMultiTexCoord1fARB");
		glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC) wglGetProcAddress("glMultiTexCoord2fARB");
		glMultiTexCoord3fARB = (PFNGLMULTITEXCOORD3FARBPROC) wglGetProcAddress("glMultiTexCoord3fARB");
		glMultiTexCoord4fARB = (PFNGLMULTITEXCOORD4FARBPROC) wglGetProcAddress("glMultiTexCoord4fARB");
		glActiveTextureARB   = (PFNGLACTIVETEXTUREARBPROC) wglGetProcAddress("glActiveTextureARB");
		glClientActiveTextureARB= (PFNGLCLIENTACTIVETEXTUREARBPROC) wglGetProcAddress("glClientActiveTextureARB");
               
#ifdef EXT_INFO
		MessageBox(hWnd,"The GL_ARB_multitexture extension will be used.","feature supported!",MB_OK | MB_ICONINFORMATION);
#endif

		return true;
	}
	useMultitexture=false;							// We Can't Use It If It Isn't Supported!
	return false;
}

/* GetWind
 * ------------------
 * Returns the wind.
 */
PVector PTerrain::GetWind()
{
	return wind;
}
