// PStartMenu.cpp: implementation of the PStartMenu class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PStartMenu.h"
#include "bitmap.h"

#define NUM_TEX 3
#define dX 0.05f

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PStartMenu::PStartMenu(PGame * pGame)
{
	ysel=-.4f;
	this ->pGame = pGame;
}

PStartMenu::~PStartMenu()
{
	
		
}

/* draws the start menu */

void PStartMenu::Draw()
{
	glPolygonMode(GL_FRONT,GL_FILL);
	
	GLuint tindices[4][3] = {
		{1,2,0}, {1,0,3}, {3,0,2}, {1,3,2}
	};
	
	GLfloat vdata[4][3] = {
		{dX,0.0f,0.0f}, {-dX,dX/2.0f,dX/2.0f}, {-dX,-dX/2.0f,dX/2.0f}, {-dX,0.0f,-dX/2.0f}
	};
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(-.2f,ysel,0.0f);
	glRotatef(trirot,1.0f,0.0f,0.0f);
	glBegin(GL_TRIANGLES);
		for(int i=0;i<4;i++) {
			glColor3f(0.0f,0.0f,.8f);
			glVertex3fv(&vdata[tindices[i][0]][0]);
			glVertex3fv(&vdata[tindices[i][1]][0]);
			glColor3f(0.0f,0.8f,0.0f);
			glVertex3fv(&vdata[tindices[i][2]][0]);
		}
	glEnd();
	trirot+=20.0f;

	glEnable(GL_TEXTURE_2D);
	glLoadIdentity();
	glTranslatef(0.0f,.3f,0.0f);
	//draw logo
	glBindTexture(GL_TEXTURE_2D, textures[0]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-.6f,-.5f,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(.6f,-.5f,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(.6f,.5f,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-.6f,.5f,0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);

	//draw start button
	glEnable(GL_TEXTURE_2D);
	glLoadIdentity();
	glTranslatef(0.0f,-.4f,0.0f);
	glBindTexture(GL_TEXTURE_2D, textures[1]);	
	glBegin(GL_QUADS);	
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-.1f,-.05f,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(.1f,-.05f,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(.1f,.05f,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-.1f,.05f,0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);

	//draw continue button
	glEnable(GL_TEXTURE_2D);
	glLoadIdentity();
	glTranslatef(0.0f,-.55f,0.0f);
	glBindTexture(GL_TEXTURE_2D, textures[31]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-.1f,-.05f,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(.1f,-.05f,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(.1f,.05f,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-.1f,.05f,0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);

	//draw options button
	glEnable(GL_TEXTURE_2D);
	glLoadIdentity();
	glTranslatef(0.0f,-.7f,0.0f);
	glBindTexture(GL_TEXTURE_2D, textures[2]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-.1f,-.05f,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(.1f,-.05f,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(.1f,.05f,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-.1f,.05f,0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);


}

/* determines what to do upon a key press */

void PStartMenu::Keyboard(unsigned char key, int x, int y)
{
	switch(key) {
		// return
		case 13: 
			if(ysel == -0.4f) pGame ->SetGameState(GS_CHARACTER_MENU); 
			else if(ysel == -0.55f) {
				int temp;
				FILE *fp;

				fp = fopen("pokemon.sav", "r");
				if(fp == 0) pGame ->SetGameState(GS_CHARACTER_MENU); 
			
				for(int i=0; i<7; i++) {
					fscanf(fp, "%d", &temp);
					pGame ->SetCharacter((POKEMON_STAT) i, temp);
				}	
				if(fp) fclose(fp);
				pGame ->StartGame();
			}
			else if(ysel == -0.7f) pGame ->SetGameState(GS_OPTIONS_MENU);
			break;
		// up (8)
		case 56: 
			if(ysel==-.4f) ysel=-.7f;
			else if(ysel==-.55f) ysel=-.4f;
			else if(ysel==-.7f) ysel=-.55f;
			break;
		//down (2)
		case 50:
			if(ysel==-.4f) ysel=-.55f;
			else if(ysel==-.55f) ysel = -.7f;
			else if(ysel==-.7f) ysel=-.4f;
			break;
		case 27:
			pGame ->QuitGame();
			break;
	}
}
