// PSplashParticle.cpp: implementation of the PSplashParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PSplashParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PSplashParticle::PSplashParticle(PGame * pGame, PDrawableObject * pSource):
	PParticle(pGame, pSource)
{
	pVolume.SetDimensions(0.0f, 0.0f, 0.0f);
	fSize = (10 + rand()%10) * 0.01;
}

PSplashParticle::~PSplashParticle()
{

}

void PSplashParticle::Draw()
{
	glDisable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, textures[44]); 

	glColor4f(0.4f, 0.4f, 1.0f, 1.0f);  

	glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex3f(0, -0.15f, -fSize);
			
		glTexCoord2f(1,0);
		glVertex3f(0, 0.15f, - fSize);
			
		glTexCoord2f(1,1);
		glVertex3f(0, 0.15f, fSize);
			
		glTexCoord2f(0,1);
		glVertex3f(0, -0.15f, fSize);	
	glEnd(); 

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND); 

	if(pDirection.z < 0 && loc.z + 0.25f<pGame->ground->GetHeight(loc.x,loc.y)) pGame ->RemoveObject(this);
	else pDirection.z -= 9.8 * pGame ->GetTimeElapsed();
}
