// PSound.h: interface for the PSound class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PSOUND_H__5538838D_2A20_453C_8D73_D24F2FC1757A__INCLUDED_)
#define AFX_PSOUND_H__5538838D_2A20_453C_8D73_D24F2FC1757A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>
#include <direct.h>
#include <dxerr8.h>
#include <dmusicc.h>
#include <dmusici.h>
#include <mmsystem.h>
#include <math.h>
#include "defines.h"
#include "resource.h"
#include "DMUtil.h"
#include "DXUtil.h"
#include "DSUtil.h"

class PSound  
{
public:
	PSound(HWND hActive);
	virtual ~PSound();
	void InitSounds();
	void DestroySounds();
	void ChangeVolume(SOUND_TYPE sType, float dist);
	HRESULT PlaySound(SOUND_TYPE sType, bool loop, float dist);
	HRESULT PlaySegment(TCHAR *strFileName, bool loop);
	void Stop();
protected:
	HRESULT LoadSegmentFile(TCHAR *strFileName);

	CMusicManager*     g_pMusicManager;
	CMusicSegment*     g_pMusicSegment;
	HWND			   hActive;
	CSoundManager*          g_pSoundManager;
	CSound*                 g_pSound;
	CSound*					thunderSound;
	CSound*					charSound;
	CSound*					fireSound;
	CSound*					squirtSound;
	CSound*					bubbleSound;
	CSound*					streamSound;
	CSound*					lavaSound;
	CSound*					waveSound;
	CSound*					rainSound;
	CSound*					windSound;
	DWORD					dwCreationFlags;
	LPDIRECTSOUND3DBUFFER   g_pDS3DBuffer;   // 3D sound buffer
	LPDIRECTSOUND3DLISTENER g_pDSListener;   // 3D listener object
	DS3DBUFFER              g_dsBufferParams;               // 3D buffer properties
	DS3DLISTENER            g_dsListenerParams;             // Listener properties
};

#endif // !defined(AFX_PSOUND_H__5538838D_2A20_453C_8D73_D24F2FC1757A__INCLUDED_)
