// PSound.cpp: implementation of the PSound class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PSound.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/* initializes the game sounds to NULL and sets up the music/sound managers */

PSound::PSound(HWND hActive)
{
	this->hActive=hActive;
    g_pMusicManager = new CMusicManager();
	g_pSoundManager=new CSoundManager();

	g_pMusicSegment=NULL;
	g_pSound=NULL;
	thunderSound=NULL;
	charSound=NULL;
	fireSound=NULL;
	squirtSound=NULL;
	bubbleSound=NULL;
	streamSound=NULL;
	lavaSound=NULL;
	waveSound=NULL;
	rainSound=NULL;
	windSound=NULL;
	g_pDS3DBuffer=NULL;
}

PSound::~PSound()
{
	delete g_pMusicManager;
	delete g_pMusicSegment;
}

/* loads a midi from a file */

HRESULT PSound::LoadSegmentFile(TCHAR* strFileName )
{
    if(g_pMusicSegment) SAFE_DELETE( g_pMusicSegment );

    // Have the loader collect any garbage now that the old 
    // script has been released
    g_pMusicManager->CollectGarbage();


    // Load the file into a DirectMusic segment 
    if( FAILED( g_pMusicManager->CreateSegmentFromFile( &g_pMusicSegment, strFileName, 
                                                        true, true ) ) ) {
        // Not a critical failure, so just update the status
        return S_FALSE;
    }

    return S_OK;
}

/* loads then plays a midi file */

HRESULT PSound::PlaySegment(TCHAR *strFileName,bool loop)
{
    HRESULT hr;

	LoadSegmentFile(strFileName);
    // Set the segment to repeat many times
	if(loop) {
	    if( FAILED( hr = g_pMusicSegment->SetRepeats( DMUS_SEG_REPEAT_INFINITE ) ) ) {
		     return DXTRACE_ERR( TEXT("SetRepeats"), hr );
	    }
	} else {
        // Set the segment to not repeat
        if( FAILED( hr = g_pMusicSegment->SetRepeats( 0 ) ) )
            return DXTRACE_ERR( TEXT("SetRepeats"), hr );
	}
    // Play the segment and wait. The DMUS_SEGF_BEAT indicates to play on the 
    // next beat if there is a segment currently playing. The first 0 indicates 
    // to play (on the next beat from) now.  
    if( FAILED( hr = g_pMusicSegment->Play( DMUS_SEGF_BEAT ) ) )
        return DXTRACE_ERR( TEXT("Play"), hr );

    return S_OK;
}

/* stops the music */

void PSound::Stop() {
	if(g_pMusicSegment!=NULL) {
		g_pMusicSegment->Stop( DMUS_SEGF_BEAT );
		g_pMusicSegment->Stop(0);
		SAFE_DELETE(g_pMusicSegment);
	}
}

/* initializes the music/sound manager */

void PSound::InitSounds() {
	HRESULT hr;

	hr=g_pSoundManager->Initialize(hActive,DSSCL_PRIORITY,2,22050,16);
	//hr |=g_pSoundManager->Get3DListenerInterface(&g_pDSListener);
    //g_dsListenerParams.dwSize = sizeof(DS3DLISTENER);
    //g_pDSListener->GetAllParameters( &g_dsListenerParams );
    g_pMusicManager->Initialize(hActive);

    //CWaveFile waveFile;
	//waveFile.Open( strFileName, NULL, WAVEFILE_READ );
    //WAVEFORMATEX* pwfx = waveFile.GetFormat();
	//hr=g_pSoundManager->Create(&g_pSound,strFileName,DSBCAPS_CTRL3D,DS3DALG_NO_VIRTUALIZATION);
}

/* changes the volume of a sound according to the distance.  the higher the distance, the softer the sound */

void PSound::ChangeVolume(SOUND_TYPE sType, float dist) {
	LONG volume=-((LONG)dist*100L);
	LPDIRECTSOUNDBUFFER pDSB;

	if(sType==SOUND_STREAM) {
		pDSB=streamSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_PIK) {
		pDSB=g_pSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_THU) {
		pDSB=thunderSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_CHAR) {
		pDSB=charSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_FIRE) {
		pDSB=fireSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_SQUIRT) {
		pDSB=squirtSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_BUBBLE) {
		pDSB=bubbleSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_LAVA) {
		pDSB=lavaSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_WAVE) {
		pDSB=waveSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_RAIN) {
		pDSB=rainSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	} else if(sType==SOUND_WIND) {
		pDSB=windSound->GetBuffer(0);
		pDSB->SetVolume(volume);
	}
}

/* stops all sound effects */

void PSound::DestroySounds() {
	if(streamSound) streamSound->Stop();
	if(g_pSound) g_pSound->Stop();
	if(thunderSound) thunderSound->Stop();
	if(charSound) charSound->Stop();
	if(fireSound) fireSound->Stop();
	if(squirtSound) squirtSound->Stop();
	if(bubbleSound) bubbleSound->Stop();
	if(lavaSound) lavaSound->Stop();
	if(waveSound) waveSound->Stop();
	if(rainSound) rainSound->Stop();
	if(windSound) windSound->Stop();
}

/* plays a sound effect...can do looping and auto-changes the volume before playing */

HRESULT PSound::PlaySound(SOUND_TYPE sType, bool loop, float dist) {
    HRESULT hr;
	char *strFileName;
	CSound *genSound;

	if(sType==SOUND_PIK) { 
		strFileName="pikachu2.wav";
		genSound=g_pSound;
	} else if(sType==SOUND_THU) {
		strFileName="thunder.wav";
		genSound=thunderSound;
	} else if(sType==SOUND_CHAR) {
		strFileName="charmander.wav";
		genSound=charSound;
	} else if(sType==SOUND_FIRE) {
		strFileName="fire.wav";
		genSound=fireSound;
	} else if(sType==SOUND_SQUIRT) {
		strFileName="squirtle.wav";
		genSound=squirtSound;
	} else if(sType==SOUND_BUBBLE) {
		strFileName="bubble.wav";
		genSound=bubbleSound;
	} else if(sType==SOUND_STREAM) {
		strFileName="stream2.wav";
		genSound=streamSound;
	} else if(sType==SOUND_LAVA) {
		strFileName="lava.wav";
		genSound=lavaSound;
	} else if(sType==SOUND_WAVE) {
		strFileName="waves.wav";
		genSound=waveSound;
	} else if(sType==SOUND_RAIN) {
		strFileName="rain.wav";
		genSound=rainSound;
	} else if(sType==SOUND_WIND) {
		strFileName="wind.wav";
		genSound=windSound;
	}


	if((sType==SOUND_CHAR || sType==SOUND_PIK || sType==SOUND_SQUIRT) && genSound!=NULL) {
		if(genSound->IsSoundPlaying()) return S_OK;
	}

	dwCreationFlags=0;
    dwCreationFlags |= DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY;
	hr=g_pSoundManager->Create(&genSound,strFileName,dwCreationFlags,GUID_NULL);
    if( NULL == genSound )
        return E_FAIL;

	if(sType==SOUND_PIK) g_pSound=genSound;
	else if(sType==SOUND_THU) thunderSound=genSound;
	else if(sType==SOUND_CHAR) charSound=genSound;
	else if(sType==SOUND_FIRE) fireSound=genSound;
	else if(sType==SOUND_SQUIRT) squirtSound=genSound;
	else if(sType==SOUND_BUBBLE) bubbleSound=genSound;
	else if(sType==SOUND_STREAM) streamSound=genSound;
	else if(sType==SOUND_LAVA) lavaSound=genSound;
	else if(sType==SOUND_WAVE) waveSound=genSound;
	else if(sType==SOUND_RAIN) rainSound=genSound;
	else if(sType==SOUND_WIND) windSound=genSound;

	ChangeVolume(sType,dist);

	if(!loop) {
	    if( FAILED( hr = genSound->Play( 0, 0 ) ) )
		     return DXTRACE_ERR( TEXT("Play"), hr );
	} else {
	    if( FAILED( hr = genSound->Play( 0, DSBPLAY_LOOPING ) ) )
		     return DXTRACE_ERR( TEXT("Play"), hr );
	}


    return S_OK;
}
