// PSnowParticle.cpp: implementation of the PSnowParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PSnowParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define SNOW_PARTS 25

void makeSnow(float x, float y, float z);

PSnowParticle::PSnowParticle(PGame *pGame, PDrawableObject *pSource, float x, float y, float z):
	PParticle(pGame,pSource)
{

	//fDistance = 1.0f;
	//fVelocity = 5.0f;
	otObjType=OBJ_TYPE_ENVIRONMENT;
	loc.x=x;
	loc.y=y;
	loc.z=z;
	this->SetDirection(&PVector(0,0,-1));
	fVelocity=(float)(rand()%100)/5.0;
	if(fVelocity==0.0) fVelocity=.1;
	lifetime=1.0;
	width=height=length=0.0;
	this ->pGame = pGame;
	this->pSource = pSource;
	pVolume.SetDimensions(0, 0, 0);
}

PSnowParticle::~PSnowParticle()
{

}

/* draws a snow particle */

void PSnowParticle::makeSnow(float x,float y, float z) {
	glColor4f(1.0,1.0,1.0,.7);
	glBegin(GL_POLYGON);
		glVertex3f(x,y,z+.05);
		glVertex3f(x,y+.03,z+.03);
		glVertex3f(x,y+.05,z);
		glVertex3f(x,y+.03,z-.03);
		glVertex3f(x,y,z-.05);
		glVertex3f(x,y-.03,z-.03);
		glVertex3f(x,y-.05,z);
		glVertex3f(x,y-.03,z+.03);
	glEnd();
}

/* draws snow particles */

void PSnowParticle::Draw()
{
	glDisable(GL_LIGHTING);
	glDisable(GL_LIGHT0);


	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
//	float r=loc.x, r1=loc.y, r2=loc.z;
//	for(int i=0;i<SNOW_PARTS;i++) {
		makeSnow(0,0,0);
//	}
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
}

/* makes the snow float down to the ground */

void PSnowParticle::Move(MOVE_CODE mcMove)
{
	PMovableObject::Move(MC_MOVE_FLOAT);
	lifetime-=.05;
	if(loc.z<pGame->ground->GetHeight(loc.x,loc.y)) {
		pGame ->RemoveObject(this);
	}
}

void PSnowParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	//do nothing, it's just snow!
}
