// PSmokeParticle.cpp: implementation of the PSmokeParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PSmokeParticle.h"
#include "PPokemon.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define SMOKE_PARTS 15

void makeSmoke(float x, float y, float z);

PSmokeParticle::PSmokeParticle(PGame *pGame, PDrawableObject *pSource):
	PParticle(pGame,pSource)
{

	//fDistance = 1.0f;
	//fVelocity = 5.0f;
	lifetime=.5;
	width=height=length=0.0;
	this ->pGame = pGame;
	this->pSource = pSource;
	pVolume.SetDimensions(0, 0, 0);
}

PSmokeParticle::~PSmokeParticle()
{

}

/* makes a smoke particle */

void PSmokeParticle::makeSmoke(float x,float y, float z) {
	glColor4f(1.0-lifetime,1.0-lifetime,1.0-lifetime,lifetime);
	glBegin(GL_QUADS);
		glVertex3f(x,y-.05,z-.05);
		glVertex3f(x,y+.05,z-.05);
		glVertex3f(x,y+.05,z+.05);
		glVertex3f(x,y-.05,z+.05);
	glEnd();
}

/* draws smoke particles */

void PSmokeParticle::Draw()
{
	glDisable(GL_LIGHTING);
	glDisable(GL_LIGHT0);


	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	float r, r1, r2;
	for(int i=0;i<SMOKE_PARTS;i++) {
		r=(float)(rand()%100)/400.0;
		r1=(float)(rand()%100)/500.0;
		r2=(float)(rand()%100)/600.0;
		if(rand()%2==0) r=-r;
		makeSmoke(r,r1,r2);
	}
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
}

/* rising smoke */

void PSmokeParticle::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(MC_MOVE_UP);
	lifetime-=.03;
	if(lifetime < 0.0 ) {
		pGame ->RemoveObject(this);
	}
}

void PSmokeParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	//do nothing, it's just smoke!
}
