// PSkyBox.cpp: implementation of the PSkyBox class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "math.h"
#include <gl\gl.h>			// Header File For The OpenGL32 Library
#include "PGame.h"
#include "PSkyBox.h"
#include "PFrustumCuller.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/* PSkyBox Constructor
 * -------------------
 * Constructor for PSkyBox.
 */
PSkyBox::PSkyBox(PGame *pGame, int xWidth, int yLength, int skyWidth, int skyLength, int height)
{
	this->pGame = pGame;
	this->xWidth = xWidth;
	this->yLength = yLength;
	this->skyWidth = skyWidth;
	this->skyLength = skyLength;
	this->height = height;
	this->pGame->culler->AddToFrustum(this, 2);
}

/* PSkyBox Destructor
 * ------------------
 * Destructor for PSkyBox.
 */
PSkyBox::~PSkyBox()
{

}

/* Draw
 * ------------------
 * Draws the SkyBox.
 * 
 */
void PSkyBox::Draw ()
{
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	int eastEdge, westEdge, northEdge, southEdge;

	westEdge = (int)floor(((float)(skyWidth - xWidth))/2.0);
	eastEdge = (int)ceil(((float)(skyWidth - xWidth))/2.0);
	northEdge = (int)ceil(((float)(skyLength - yLength))/2.0);
	southEdge = (int)floor(((float)(skyLength - yLength))/2.0);
	//glDisable(GL_TEXTURE_2D);
	//glEnable(GL_TEXTURE_2D);

	if(pGame->GetStage()==0) glBindTexture(GL_TEXTURE_2D, textures[22]);
	else if(pGame->GetStage()==1) glBindTexture(GL_TEXTURE_2D, textures[47]);
	else if(pGame->GetStage()==2) glBindTexture(GL_TEXTURE_2D, textures[50]);
	else if(pGame->GetStage()==3) glBindTexture(GL_TEXTURE_2D, textures[55]);


//east wall
	glBegin(GL_QUADS);	
		glTexCoord2f(0.0f,0.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(-eastEdge),-10.0f);
		glTexCoord2f(1.0f,0.0f);
		glVertex3f((float)(-southEdge),(float)(-eastEdge),-10.0f);
		glTexCoord2f(1.0f,1.0f);
		glVertex3f((float)(-southEdge),(float)(-eastEdge),
					(float)(height - 10));
		glTexCoord2f(0.0f,1.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(-eastEdge),
					(float)(height - 10));
	glEnd();

//north wall
	//glBindTexture(GL_TEXTURE_2D, textures[22]);
	glBegin(GL_QUADS);	
		glTexCoord2f(0.0f,0.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(westEdge + yLength),-10.0f);
		glTexCoord2f(1.0f,0.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(-eastEdge),-10.0f);
		glTexCoord2f(1.0f,1.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(-eastEdge),
					(float)(height - 10));
		glTexCoord2f(0.0f,1.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(westEdge + yLength),
					(float)(height - 10));
	glEnd();

//west wall
	//glBindTexture(GL_TEXTURE_2D, textures[22]);
	glBegin(GL_QUADS);	
		glTexCoord2f(0.0f,0.0f);
		glVertex3f((float)(-southEdge),(float)(westEdge + yLength),-10.0f);
		glTexCoord2f(1.0f,0.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(westEdge + yLength),-10.0f);
		glTexCoord2f(1.0f,1.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(westEdge + yLength),
					(float)(height - 10));
		glTexCoord2f(0.0f,1.0f);
		glVertex3f((float)(-southEdge),(float)(westEdge + yLength),
					(float)(height - 10));
	glEnd();

//south wall
	//glBindTexture(GL_TEXTURE_2D, textures[22]);
	glBegin(GL_QUADS);	
		glTexCoord2f(0.0f,0.0f);
		glVertex3f((float)(-southEdge),(float)(-eastEdge),-10.0f);
		glTexCoord2f(1.0f,0.0f);
		glVertex3f((float)(-southEdge),(float)(westEdge + yLength),-10.0f);
		glTexCoord2f(1.0f,1.0f);
		glVertex3f((float)(-southEdge),(float)(westEdge + yLength),
					(float)(height - 10));
		glTexCoord2f(0.0f,1.0f);
		glVertex3f((float)(-southEdge),(float)(-eastEdge),
					(float)(height - 10));
	glEnd();

//top wall
/*	glBindTexture(GL_TEXTURE_2D, textures[22]);
	glBegin(GL_QUADS);	
		glTexCoord2f(0.0f,0.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(westEdge + yLength),
					(float)(skyBox - 10));
		glTexCoord2f(1.0f,0.0f);
		glVertex3f((float)(northEdge + xWidth),(float)(-eastEdge),
					(float)(skyBox - 10));
		glTexCoord2f(1.0f,1.0f);
		glVertex3f((float)(-southEdge),(float)(-eastEdge),
					(float)(skyBox - 10));
		glTexCoord2f(0.0f,1.0f);
		glVertex3f((float)(-southEdge),(float)(westEdge + yLength),
					(float)(skyBox - 10));
	glEnd();*/
}

/* Set(Variable)
 * ------------------
 * Sets various variables.
 */
void PSkyBox::SetHeight(int height)
{
	this->height = height;
}

void PSkyBox::SetXWidth (int xWidth)
{
	this->xWidth = xWidth;
}

void PSkyBox::SetYLength (int yLength)
{
	this->yLength = yLength;
}

void PSkyBox::SetSkyWidth (int skyWidth)
{
	this->skyWidth = skyWidth;
}

void PSkyBox::SetSkyLength (int skyLength)
{
	this->skyLength = skyLength;
}

/* GetHeight
 * ------------------
 * Returns various variable values.
 */
int PSkyBox::GetHeight(void)
{
	return(height);
}

int PSkyBox::GetXWidth(void)
{
	return (xWidth);
}

int PSkyBox::GetYLength(void)
{
	return (yLength);
}

int PSkyBox::GetSkyWidth(void)
{
	return (skyWidth);
}

int PSkyBox::GetSkyLength(void)
{
	return (skyLength);
}
