// PRainParticle.cpp: implementation of the PRainParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PRainParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void makeRain(float x, float y, float z);

PRainParticle::PRainParticle(PGame *pGame, PDrawableObject *pSource, float x, float y, float z):
	PParticle(pGame,pSource)
{

	//fDistance = 1.0f;
	//fVelocity = 5.0f;
	otObjType=OBJ_TYPE_ENVIRONMENT;
	loc.x=x;
	loc.y=y;
	loc.z=z;
	this->SetDirection(&PVector(0,0,-1));
	fVelocity=15.0+rand()%10;;
	if(fVelocity==0.0) fVelocity=.1;
	lifetime=1.0;
	width=height=length=0.0;
	this ->pGame = pGame;
	this->pSource = pSource;
	pVolume.SetDimensions(0, 0, 0);
}

PRainParticle::~PRainParticle()
{

}

/* draws a rain particle */

void PRainParticle::makeRain(float x,float y, float z) {
	glColor4f(.7,.7,.7,.7);
	glBegin(GL_QUADS);
		glVertex3f(x,y+.01,z+.1);
		glVertex3f(x,y+.01,z-.1);
		glVertex3f(x,y-.01,z-.1);
		glVertex3f(x,y-.01,z+.1);
	glEnd();
}

/* draws rain particles */

void PRainParticle::Draw()
{
	glDisable(GL_LIGHTING);
	glDisable(GL_LIGHT0);


	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
//	float r=loc.x, r1=loc.y, r2=loc.z;
//	for(int i=0;i<SNOW_PARTS;i++) {
		makeRain(0,0,0);
//	}
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
}

/* moves the rain particle downwards */

void PRainParticle::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(MC_MOVE_RAIN);
	lifetime-=.05;
	if(loc.z<pGame->ground->GetHeight(loc.x,loc.y)) {
		pGame ->RemoveObject(this);
	}
}

void PRainParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	//do nothing, it's just rain!
}
