// PProjectileThread.cpp: implementation of the PProjectileThread class.
//
//////////////////////////////////////////////////////////////////////
// The ProjectileThread controls the movement of all the projectiles in the world
// by calling their move() methods
////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "PProjectileThread.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PProjectileThread::PProjectileThread(PGame * pGame)
{
	this ->pGame = pGame;
}

PProjectileThread::~PProjectileThread()
{

}

int PProjectileThread::Run()
{
	CPtrArray * pProjectiles = pGame ->GetObjects(OBJ_TYPE_PROJECTILE);
	PProjectile * pProjectile;
	//CSingleLock cLock(&cCriticalSection);
	for(;;) {
		if(!bIsRunning) break;
		//cLock.Lock();
		for(int i=0; i < pProjectiles ->GetSize(); i++) {
			pProjectile = (PProjectile *)pProjectiles ->GetAt(i);
			pProjectile ->SetTimeElapsed();
			pProjectile ->Move(MC_MOVE_FORWARD);
		}
		//cLock.Unlock();
	}

	cTerminationEvent.SetEvent();
	return 0;
}






