// PPokemonAI.h: interface for the PPokemonAI class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PPOKEMONAI_H__396DE1CF_CDBE_4F96_993D_90E58D2819FF__INCLUDED_)
#define AFX_PPOKEMONAI_H__396DE1CF_CDBE_4F96_993D_90E58D2819FF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define NUM_ACTIONS 14
#define NUM_EVENTS 4
#define MAX_DIFF_VALUES 6

#include "PPokemon.h"
#include "defines.h"	// Added by ClassView

class PPokemonAI  
{
public:
	bool IsLearning();
	void ToggleLearning(bool bLearn);
	void SetModel(PPokemon * pModel);
	void Evaluate(AI_MOVE aiMove);
	AI_MOVE GuessMove();
	PPokemonAI();
	virtual ~PPokemonAI();

protected:
	bool bLearn;
	PPokemon * pModel;
	void AdjustProb(AI_MOVE aiMove, bool correct);
	float Query(AI_MOVE aiMove);
	void ObserveEvents();
	int aEvents[NUM_EVENTS];
	float aProbTable[NUM_ACTIONS][NUM_EVENTS][MAX_DIFF_VALUES + 1];
};

#endif // !defined(AFX_PPOKEMONAI_H__396DE1CF_CDBE_4F96_993D_90E58D2819FF__INCLUDED_)
