// PPokemon.h: interface for the PPokemon class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PPOKEMON_H__0A8534A2_6C3C_44D7_A39D_7F4D1255C377__INCLUDED_)
#define AFX_PPOKEMON_H__0A8534A2_6C3C_44D7_A39D_7F4D1255C377__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PMovableObject.h"
#include "pvector.h"	// Added by ClassView

class PPokemon:
	public PMovableObject  
{
public:
	void GainLevel();
	void GenerateStatsAI(int iLevel);
	void SetStat(POKEMON_STAT stat, int value);
	int GetStat(POKEMON_STAT stat);
	bool IsBlocking();
	void MoveSpecialAI(MOVE_CODE mcMove);
	void ChangeEnergy(ENERGY_TYPE eType, float value);
	float GetFlipRotation();
	bool IsValidMove(MOVE_CODE mcMove);
	char * GetName();
	int GetLevel();
	GLuint GetTextureID();
	
	void SetTarget(PPokemon * pTarget);
	PPokemon * GetTarget();
	
	float GetEnergy(ENERGY_TYPE eType);
	bool IsAlive();
		
	void ToggleMove(MOVE_CODE mcMove, bool value);
	void Move();
	virtual POKEMON_TYPE GetPokemonType()=0;
	virtual void Move(MOVE_CODE mcMove);
	virtual void Attack(ATTACK_CODE acAttack) = 0;
	
	virtual void TakeDamage(DAMAGE_TYPE dtType, float fDamage);
	void RecoverEnergy();
	
	void SetAI(bool bAIOn);
	bool AIOn();

	PPokemon();
	virtual ~PPokemon();

protected:
	bool EnemyThreatAI();
	bool MoveAllowedAI(MOVE_CODE mcMove);
	bool AttackAI(PVector * vTarget);
	PVector FindPathAI(PVector * vTarget);
	PVector AdjustTargetLoc(AI_MOVE move);
	void MoveAI();
	void MoveTowardsTargetAI(PVector * vTarget);
	AI_GOAL GoalAI();
	int iAgression;
	clock_t tBlock;

	float fCurrentLifeEnergy, fDamage;
	float fLifeEnergy, fAttackEnergy, fSpeedEnergy;
	float fLifeRecovery, fAttackRecovery, fSpeedRecovery;
	float fDamageRate;

	float fRollRotation, fFlipRotation;
	float fRunVelocity;
	bool aMoves[NUM_MOVES];
	bool bAIOn;

	char strName[20];

	PPokemon * pTarget;
	GLuint iTextureID;
	int iCharacter, iLevel;
	int iExperience; int iNextLevel;
	int iHP, iAttack, iSpeed;
};

#endif // !defined(AFX_PPOKEMON_H__0A8534A2_6C3C_44D7_A39D_7F4D1255C377__INCLUDED_)
