// PPokeball.cpp: implementation of the PPokeball class.
//
//////////////////////////////////////////////////////////////////////
// adapted from icosohedron code in the OpenGL programming guide to draw the pokeball

#include "stdafx.h"
#include "PPokeball.h"

#define X .525731112119133606
#define Z .850650808352039932

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PPokeball::PPokeball()
{

}

PPokeball::~PPokeball()
{

}

GLfloat PPokeball::vdata[12][3] = {
	{ -X, 0.0, Z}, {X, 0.0, Z}, {-X, 0.0, -Z}, {X, 0.0, -Z},
	{ 0.0, Z, X }, {0.0, Z, -X}, {0.0, -Z, X}, {0.0, -Z, -X},
	{ Z, X, 0.0}, { -Z, X, 0.0 }, {Z, -X, 0.0}, {-Z, -X, 0.0}
};

GLuint PPokeball::tindices[20][3] = {
	{1,4,0}, {4,9,0}, {4,5,9}, {8,5,4}, {1,8,4},
	{1,10,8}, {10,3,8}, {8,3,5}, {3,2,5}, {3,7,2},
	{3,10,7}, {10,6,7}, {6,11,7}, {6,0,11}, {6,1,0},
	{10,1,6}, {11,0,9}, {2,11,9}, {5,2,9}, {11,2,7}
};

GLfloat PPokeball::red[4] = { 1.0, 0.0, 0.0, 1.0 };
GLfloat PPokeball::white[4] = { 1.0, 1.0, 1.0, 1.0};
GLfloat PPokeball::black[4] = { 0.0, 0.0, 0.0, 1.0};

void PPokeball::Draw()
{
	glScalef(0.5f, 0.5f, 0.5f);
	GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
	GLfloat mat_shininess[] = { 100.0 };
	
	glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
	glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);

	
	for(int i=0; i<20; i++) {
		Subdivide(&vdata[tindices[i][0]][0],
				  &vdata[tindices[i][1]][0],
				  &vdata[tindices[i][2]][0], 4);

	}


	glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, black);

	glScalef(1.0f, 1.0f, 0.3f);
	glutSolidTorus(0.52f, 0.5f, 25, 25);
}

void PPokeball::DrawTriangle(float *v1, float *v2, float *v3)
{

	
	bool bWhite = v1[2] < 0.0f || v2[2] < 0.0f || v3[2] < 0.0f;
	if(bWhite) {
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, white);
	} else {	
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, red);
	}

	glBegin(GL_TRIANGLES);
		glNormal3fv(v1);
		glVertex3fv(v1);
		glNormal3fv(v2);
		glVertex3fv(v2);
		glNormal3fv(v3);
		glVertex3fv(v3);
	glEnd();
}

void PPokeball::Subdivide(float *v1, float *v2, float *v3, int depth)
{
	GLfloat v12[3], v23[3], v31[3];

	if(depth == 0) {
		DrawTriangle(v1, v2, v3);
		return;
	}

	for(int i=0; i<3; i++) {
		v12[i] = (v1[i] + v2[i]) * 0.5f;
		v23[i] = (v2[i] + v3[i]) * 0.5f;
		v31[i] = (v3[i] + v1[i]) * 0.5f;
	}

	Normalize(v12);
	Normalize(v23);
	Normalize(v31);
	Subdivide(v1, v12, v31, depth - 1);
	Subdivide(v2, v23, v12, depth - 1);
	Subdivide(v3, v31, v23, depth - 1);
	Subdivide(v12, v23, v31, depth - 1);
}

void PPokeball::Normalize(float v[3])
{
	GLfloat d = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);

	if(d == 0.0f) {
		return;
	} else {
		d = 1.0f / d;
	}

	v[0] *= d;
	v[1] *= d;
	v[2] *= d;
}
