// PPoint.h: interface for the PPoint class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PPOINT_H__A9100846_32A2_48B0_A900_EEDA9891AD42__INCLUDED_)
#define AFX_PPOINT_H__A9100846_32A2_48B0_A900_EEDA9891AD42__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "pvector.h"
#include "defines.h"

class PPoint : public PVector  
{
public:
	float AngleTo(PVector * pTarget);
	PPoint(PVector & source);
	PPoint(PPoint & source);
	PPoint();
	void Rotate(AXIS axis, float theta);
	void Scale(float xScale, float yScale, float zScale);
	void Translate(float dx, float dy, float dz);
	PPoint(float x, float y, float z);
	virtual ~PPoint();
	void operator=(PPoint & source) { x = source.x; y = source.y; z = source.z; }
};

#endif // !defined(AFX_PPOINT_H__A9100846_32A2_48B0_A900_EEDA9891AD42__INCLUDED_)
