// POptionsMenu.cpp: implementation of the POptionsMenu class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "POptionsMenu.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

POptionsMenu::POptionsMenu(PGame * pGame)
{
	optseloffsetx=.02f;
	optseloffsety=.02f;
	optionx=-.55f;
	optiony=.4f;
	diffx=.3f;
	enx=0.0f;
	soundx=.15f;
	this ->pGame = pGame;
}

POptionsMenu::~POptionsMenu()
{

}

/* draws the options menu */

void POptionsMenu::Draw()
{
	GLfloat optx=.3f,opty=.1f,backx=.2f,backy=.1f;
	
	//draw option texture
	glEnable(GL_TEXTURE_2D);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(-.75f,.8f,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[6]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-optx,-opty,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(optx,-opty,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(optx,opty,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-optx,opty,0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);

	SelectOptBox(optx+optseloffsetx,opty+optseloffsety);

	glEnable(GL_TEXTURE_2D);
	//draw menu.difficulty
	DrawDifficulty(optx,opty);

	//draw sound
	DrawSound(optx,opty);

	//draw back to menu
	glLoadIdentity();
	glTranslatef(.7f,-.8f,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[8]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-backx,-backy,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(backx,-backy,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(backx,backy,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-backx,backy,0.0f);
	glEnd();

}

/* determines what happens with right/left, up/down, and enter */

void POptionsMenu::Keyboard(unsigned char key, int x, int y)
{
	switch(key) {
	// return
	case 13:
		if(optiony==-.8f) {
			optionx=-.55f;
			optiony=.4f;
			optseloffsetx=.02f;
			optseloffsety=.02f;
			pGame ->SetGameState(GS_START_MENU);
		}
		break;
	// left (4)
	case 52:
		if(optiony==.4f && diffx==.3f) {	/* determine difficulty level */
			diffx=0.0f;
			pGame ->SetGameOption(GO_DIFFICULTY, 1);
		} else if(optiony==.4f && diffx==0.0f) {
			diffx=.6f;
			pGame ->SetGameOption(GO_DIFFICULTY, 3);
		} else if(optiony==.4f && diffx==.6f) {
			diffx=.3f;
			pGame ->SetGameOption(GO_DIFFICULTY, 2);
		} else if(optiony==0.0f && enx==.3f) {	/* determine num of enemies */
			enx=0.0f;
			pGame ->SetGameOption(GO_NUM_ENEMIES, 1);
		} else if(optiony==0.0f && enx==0.0f) {
			enx=.6f;
			pGame ->SetGameOption(GO_NUM_ENEMIES, 3);
		} else if(optiony==0.0f && enx==.6f) {
			enx=.3f;
			pGame ->SetGameOption(GO_NUM_ENEMIES, 2);
		} else if(optiony==-.4f && soundx==.15f) {	/* determine if sound is on/off */
			soundx=.45f;
			pGame->SetGameOption(GO_SOUND,0);
		} else if(optiony==-.4f && soundx==.45f) {
			soundx=.15f;
			pGame->SetGameOption(GO_SOUND,1);
		}
		break;
	// right (6)
	case 54:
		if(optiony==.4f && diffx==.3f) {
			diffx=0.6f;
			pGame ->SetGameOption(GO_DIFFICULTY, 3);
		} else if(optiony==.4f && diffx==0.0f) {
			diffx=.3f;
			pGame ->SetGameOption(GO_DIFFICULTY, 2);
		} else if(optiony==.4f && diffx==.6f) {
			diffx=0.0f;
			pGame ->SetGameOption(GO_DIFFICULTY, 1);
		} else if(optiony==0.0f && enx==.3f) {
			enx=0.6f;
			pGame ->SetGameOption(GO_NUM_ENEMIES, 3);
		} else if(optiony==0.0f && enx==0.0f) {
			enx=.3f;
			pGame ->SetGameOption(GO_NUM_ENEMIES, 2);
		} else if(optiony==0.0f && enx==.6f) {
			enx=0.0f;
			pGame ->SetGameOption(GO_NUM_ENEMIES, 1);
		} else if(optiony==-.4f && soundx==.15f) {	/* determine if sound is on/off */
			soundx=.45f;
			pGame->SetGameOption(GO_SOUND,0);
		} else if(optiony==-.4f && soundx==.45f) {
			soundx=.15f;
			pGame->SetGameOption(GO_SOUND,1);
		} 
		break;
	// up (8)
	case 56: 
		if(optiony==.4f) {		/* determine which option to change */
			optionx=.7f;
			optiony=-.8f;
			optseloffsetx=-.08f;
			optseloffsety=.02f;
		} else if(optiony==-.4f) {
			//optiony=0.0f;
			optiony=.4f;
		} else if(optiony==0.0f) {
				optiony=.4f;
		} else if(optiony==-.8f) {
			optionx=-.55f;
			optiony=-.4f;
			optseloffsetx=.02f;
			optseloffsety=.02f;
		}
		break;
	//down (2)
	case 50:
		if(optiony==.4f) {		/* determine which option to change */
			//optiony=0.0f;
			optiony=-.4f;
		} else if(optiony==-.4f) {
			optionx=.7f;
			optiony=-.8f;
			optseloffsetx=-.08f;
			optseloffsety=.02f;
		} else if(optiony==0.0f) {
			optiony=-.4f;
		} else if(optiony==-.8f) {
			optionx=-.55f;
			optiony=.4f;
			optseloffsetx=.02f;
			optseloffsety=.02f;
		} 
		break;
	
	//esc
	case 27:
		pGame ->SetGameState(GS_START_MENU);
		break;
	}
}

/* the select box for the options menu */

void POptionsMenu::SelectOptBox(GLfloat optx, GLfloat opty)
{
	glLoadIdentity();	
	glTranslatef(optionx,optiony,0.0f);
	glBegin(GL_QUADS);
		glColor3f(0.0,0.0,.8);
		glNormal3f(0.0f,0.0f,1.0f);
		glVertex3f(-optx,-opty,0.0f);
		glVertex3f(optx,-opty,0.0f);
		glVertex3f(optx,opty,0.0f);
		glVertex3f(-optx,opty,0.0f);
	glEnd();		
}

void POptionsMenu::DrawDifficulty(GLfloat optx, GLfloat opty)
{
	GLfloat x=.1f,y=.08f,height=.38f;
	//draw menu.difficulty
	glLoadIdentity();
	glTranslatef(-.55f,.4f,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[9]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-optx,-opty,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(optx,-opty,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(optx,opty,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-optx,opty,0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);

	SelectDiffBox(x+.01,y+.01,height);

	glEnable(GL_TEXTURE_2D);
	//draw easy
	glLoadIdentity();
	glTranslatef(0.0f,height,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[12]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-x,-y,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(x,-y,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(x,y,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-x,y,0.0f);
	glEnd();

	//draw medium
	glLoadIdentity();
	glTranslatef(.3f,height,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[13]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-x,-y,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(x,-y,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(x,y,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-x,y,0.0f);
	glEnd();

	//draw hard
	glLoadIdentity();
	glTranslatef(.6f,height,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[14]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-x,-y,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(x,-y,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(x,y,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-x,y,0.0f);
	glEnd();
}

/*
void POptionsMenu::DrawEnemies(GLfloat optx, GLfloat opty)
{
	GLfloat x=.06f,y=.08f,height=-.01f;
	//draw num of menu.enemies
	glLoadIdentity();
	glTranslatef(-.55f,0.0f, 0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[10]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-optx,-opty,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(optx,-opty,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(optx,opty,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-optx,opty,0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);
	
	SelectEnBox(x+.01f,y+.01f,height);

	glEnable(GL_TEXTURE_2D);
	//draw 1
	glLoadIdentity();
	glTranslatef(0.0f,height,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[15]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-x,-y,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(x,-y,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(x,y,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-x,y,0.0f);
	glEnd();

	//draw 2
	glLoadIdentity();
	glTranslatef(.3f,height,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[16]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-x,-y,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(x,-y,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(x,y,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-x,y,0.0f);
	glEnd();

	//draw 3
	glLoadIdentity();
	glTranslatef(.6f,height,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[17]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-x,-y,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(x,-y,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(x,y,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-x,y,0.0f);
	glEnd();
}*/

/* determines if you want sound in the game */

void POptionsMenu::DrawSound(GLfloat optx, GLfloat opty)
{
	GLfloat x=.1f,y=.08f,height=-.43f;

	//draw Sound
	glLoadIdentity();
	glTranslatef(-.55f,-.4f, 0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[11]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-optx,-opty,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(optx,-opty,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(optx,opty,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-optx,opty,0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);

	SelectSoundBox(x+.01f,y+.01f,height);

	glEnable(GL_TEXTURE_2D);
	//draw on
	glLoadIdentity();
	glTranslatef(.15f,height,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[18]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-x,-y,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(x,-y,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(x,y,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-x,y,0.0f);
	glEnd();

	//draw off
	glLoadIdentity();
	glTranslatef(.45f,height,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[19]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-x,-y,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(x,-y,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(x,y,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-x,y,0.0f);
	glEnd();
}

/* a selection box for the difficulty */

void POptionsMenu::SelectDiffBox(GLfloat x, GLfloat y, GLfloat height)
{
	glLoadIdentity();
	glTranslatef(diffx,height,0.0f);
	glBegin(GL_QUADS);
		glColor3f(0.0,0.8,0.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glVertex3f(-x,-y,0.0f);
		glVertex3f(x,-y,0.0f);
		glVertex3f(x,y,0.0f);
		glVertex3f(-x,y,0.0f);
	glEnd();
}

/*

void POptionsMenu::SelectEnBox(GLfloat x, GLfloat y, GLfloat height)
{
	glLoadIdentity();
	glTranslatef(enx,height,0.0f);
	glBegin(GL_QUADS);
		glColor3f(0.0,0.8,0.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glVertex3f(-x,-y,0.0f);
		glVertex3f(x,-y,0.0f);
		glVertex3f(x,y,0.0f);
		glVertex3f(-x,y,0.0f);
	glEnd();
}
*/

/* a selection box for the sound */

void POptionsMenu::SelectSoundBox(GLfloat x, GLfloat y, GLfloat height)
{
	glLoadIdentity();
	glTranslatef(soundx,height,0.0f);
	glBegin(GL_QUADS);
		glColor3f(0.0,0.8,0.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glVertex3f(-x,-y,0.0f);
		glVertex3f(x,-y,0.0f);
		glVertex3f(x,y,0.0f);
		glVertex3f(-x,y,0.0f);
	glEnd();
}
