// PMovableObject.h: interface for the PMovableObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PMOVABLEOBJECT_H__41B2E731_FFBD_4EE6_BFD9_34BBF100B433__INCLUDED_)
#define AFX_PMOVABLEOBJECT_H__41B2E731_FFBD_4EE6_BFD9_34BBF100B433__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PDrawableObject.h"
#include "PGame.h"
#include "time.h"
#include "pvector.h"	// Added by ClassView

class PMovableObject : 
	public PDrawableObject
{
public:
	void SetDirection(PVector * v);
	PVector GetDirectionVector();
	virtual void Rotate(AXIS axis, float fAngle);
	void SetVelocity(float fVelocity);
	float GetVelocity() { return fVelocity; }
	virtual void Move(MOVE_CODE mcMove);
	float GetDirection();
	void RotateToCamera();
	
	PMovableObject();
	virtual ~PMovableObject();
protected:
	float fVelocity;
	float fRotationRate;
	PVector pDirection;
	PVector pDirection2D;
	
	PGame * pGame;
};

#endif // !defined(AFX_PMOVABLEOBJECT_H__41B2E731_FFBD_4EE6_BFD9_34BBF100B433__INCLUDED_)
