// PMovableObject.cpp: implementation of the PMovableObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PMovableObject.h"
#include "PCamera.h"
#include "GL/glut.h"
#include "math.h"
#include "PTrackParticle.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PMovableObject::PMovableObject()
{
	// initializes direction to point down x-axis towards positive x

	fVelocity = 0.1f;

	fRotationRate = 90.0f;

	pDirection.set(1.0f, 0.0f, 0.0f);
	pDirection2D.set(1.0f, 0.0f, 0.0f);
	groundBound = false;
	sideBound = false;
}

PMovableObject::~PMovableObject()
{

}

float FindLowest(float f, float l, float r, float b, float ur, float ul, float lr, float ll) {
	if(f<=l && f<=r && f<=b && f<=ur && f<=ul && f<=lr && f<=ll) return f;
	else if(l<=f && l<=r && l<=b && l<=ur && l<=ul && l<=lr && l<=ll) return l;
	else if(r<=l && r<=f && r<=b && r<=ur && r<=ul && r<=lr && r<=ll) return r;
	else if(b<=l && b<=r && b<=f && b<=ur && b<=ul && b<=lr && b<=ll) return b;
	else if(ur<=l && ur<=r && ur<=b && ur<=f && ur<=ul && ur<=lr && ur<=ll) return ur;
	else if(ul<=l && ul<=r && ul<=b && ul<=ur && ul<=f && ul<=lr && ul<=ll) return ul;
	else if(lr<=l && lr<=r && lr<=b && lr<=ur && lr<=ul && lr<=f && lr<=ll) return lr;
	else return ll;
}

void PMovableObject::Move(MOVE_CODE mcMove)
{
	float newx, newy, newz;
	newx = loc.x;
	newy = loc.y;
	newz = loc.z;

	float dir = 1.0f;

	float fTimeElapsed = pGame ->GetTimeElapsed();
	PVector wind=pGame ->ground ->GetWind();

	switch(mcMove) {
	case MC_MOVE_SURROUND: break;
	case MC_MOVE_FLOAT:
		SetCoordinates(loc.x + wind.x, loc.y + wind.y, loc.z + pDirection.z * fVelocity * dir * fTimeElapsed);
		return;
	case MC_MOVE_RAIN:
		SetCoordinates(loc.x, loc.y, loc.z+pDirection.z*fVelocity*dir*fTimeElapsed);
		return;
	case MC_MOVE_DOWN:
		newy = loc.y + fVelocity * dir * fTimeElapsed;
		float forward,left, right, back, upperright,upperleft, lowerright, lowerleft,down,dirx,diry,dirz;

		if(fVelocity==2.5) dirx=diry=dirz=0;
		else if(fVelocity==.5) dirx=diry=dirz=.1;

		forward=pGame->ground->GetHeight(newx, newy);
		newx = loc.x + fVelocity * dir * fTimeElapsed;
		upperright=pGame->ground->GetHeight(newx, newy);
		newy=loc.y;
		right=pGame->ground->GetHeight(newx, newy);
		newy=loc.y - fVelocity * dir * fTimeElapsed;
		lowerright=pGame->ground->GetHeight(newx, newy);
		newx=loc.x;
		back=pGame->ground->GetHeight(newx, newy);
		newx=loc.x - fVelocity * dir * fTimeElapsed;
		lowerleft=pGame->ground->GetHeight(newx, newy);
		newy=loc.y;
		left=pGame->ground->GetHeight(newx, newy);
		newy=loc.y + fVelocity * dir * fTimeElapsed;
		upperleft=pGame->ground->GetHeight(newx, newy);

		down=FindLowest(forward,left,right,back,upperright,upperleft,lowerright,lowerleft);

		if(down==forward) {
			newx=loc.x;
			newy=loc.y+fVelocity*dir*fTimeElapsed;
			pDirection.set(0.0,.5-diry,-.5+dirz);
		} else if(down==upperright) {
			newx=loc.x+fVelocity*dir*fTimeElapsed;
			newy=loc.y+fVelocity*dir*fTimeElapsed;
			pDirection.set(.33-dirx,.33-diry,-.33+dirz);
		} else if(down==right) {
			newx=loc.x+fVelocity*dir*fTimeElapsed;
			newy=loc.y;
			pDirection.set(.5-dirx,0.0,-.5+dirz);
		} else if(down==lowerright) {
			newx=loc.x+fVelocity*dir*fTimeElapsed;
			newy=loc.y-fVelocity*dir*fTimeElapsed;
			pDirection.set(.33-dirx,-.33+diry,-.33+diry);
		} else if(down==back) {
			newx=loc.x;
			newy=loc.y-fVelocity*dir*fTimeElapsed;
			pDirection.set(0.0,-.5+diry,-.5+dirz);
		} else if(down==lowerleft) {
			newx=loc.x-fVelocity*dir*fTimeElapsed;
			newy=loc.y-fVelocity*dir*fTimeElapsed;
			pDirection.set(-.33+dirx,-.33+diry,-.33+dirz);
		} else if(down==left) {
			newx=loc.x-fVelocity*dir*fTimeElapsed;
			newy=loc.y;
			pDirection.set(-.5+dirx,0.0,-.5+dirz);
		} else if(down==upperleft) {
			newx=loc.x-fVelocity*dir*fTimeElapsed;
			newy=loc.y+fVelocity*dir*fTimeElapsed;
			pDirection.set(-.33+dirx,.33-diry,-.33+dirz);
		} else {
			newx=loc.x;
			newy=loc.y;
			pDirection.set(0.0,0.0,0.0);
		}
		newz=pGame->ground->GetHeight(newx,newy);
		break;
	case MC_MOVE_UP:
		newz+=.2;
		break;
	case MC_MOVE_BACK:
		dir = -1.0f;
	case MC_MOVE_FORWARD:
		newx = loc.x + pDirection.x * fVelocity * dir * fTimeElapsed;
		newy = loc.y + pDirection.y * fVelocity * dir * fTimeElapsed;
		if (sideBound) {
			if ((double)(pGame->ground->GetXWidth() - 1) < newx) {
				newx = loc.x;
			}
			else if (newx < 0) {
				newx = loc.x;
			}
			if ((double)(pGame->ground->GetYLength() - 1) < newy) {
				newy = loc.y;
			}
			else if (newy < 0) {
				newy = loc.y;
			}
		}
		if (groundBound) {
			newz = pGame->ground->GetHeight((double)newx, (double)newy);
		}
		else {
			newz = loc.z + pDirection.z * fVelocity * fTimeElapsed;
		}


		break;
	case MC_MOVE_RIGHT:
		dir = -1.0f;
	case MC_MOVE_LEFT:
		newx = loc.x - pDirection.y * fVelocity * dir * fTimeElapsed * 1.5f;
		newy = loc.y + pDirection.x * fVelocity * dir * fTimeElapsed * 1.5f;
		if (sideBound) {
			if ((double)(pGame->ground->GetXWidth() - 1) < newx) {
				newx = loc.x;
			}
			else if (newx < 0) {
				newx = loc.x;
			}
			if ((double)(pGame->ground->GetYLength() - 1) < newy) {
				newy = loc.y;
			}
			else if (newy < 0) {
				newy = loc.y;
			}
		}
		if (groundBound) {
			newz = pGame->ground->GetHeight((double)newx, (double)newy);
		}
		else {
			newz = loc.z + pDirection.z * fVelocity * fTimeElapsed;
		}
		break;

	case MC_ROTATE_RIGHT:
		Rotate(AXIS_Z, fRotationRate * fTimeElapsed);
		break;

	case MC_ROTATE_LEFT:
		Rotate(AXIS_Z, -fRotationRate * fTimeElapsed);
		break;
	case MC_MOVE_FALL:
		newz = loc.z + pDirection.z * fTimeElapsed;
		if(newz < pGame->ground->GetHeight(newx, newy)) {
			newz = pGame ->ground ->GetHeight(newx, newy);
			pDirection.z = 0.0f;
		} else {
			pDirection.z -= 9.8f * fTimeElapsed;
		}
		break;
	case MC_MOVE_NOTHING:
		if (groundBound) {
			newz = pGame->ground->GetHeight((double)newx, (double)newy);
		}
	}

	float newrx, newry;
	newrx = newry = 0.0f;

	// rotate so object is oriented along hill
	if(groundBound) {
		if(pGame ->ground ->GetHeight(newx, newy) < 0.0f) {
			newx = loc.x;
			newy = loc.y;
		}

		PVector pNormal = pGame ->ground -> GetNormal(newx, newy);
	
		if(ABS(pDirection2D.x) > ABS(pDirection2D.y)) {
			float fFactor = 1 - ABS(pDirection2D.y);
			newry = (90.0f - DEGREE(pDirection2D.angleSubtended(AXIS_Y, &pNormal))) * fFactor;
		}
		else {
			float fFactor = 1 - ABS(pDirection2D.x);
			newry = (90.0f - DEGREE(pDirection2D.angleSubtended(AXIS_X, &pNormal))) * fFactor;
		}
	}

	// don't detect collision for rotation....
	bool collide = false;
	float tmpx,tmpy,tmpz;
	if(mcMove != MC_ROTATE_RIGHT && mcMove != MC_ROTATE_LEFT) {
		pVolume.SetCoordinates(newx, newy, newz);
		pVolume.SetRotation(newrx, newry, rz);
	
		CPtrArray aCollidingObjects;
		pGame ->DetectCollisions(this, & pVolume, & aCollidingObjects);

		PDrawableObject * pCollidingObject;
		for(int i=0; i<aCollidingObjects.GetSize(); i++) {
			pCollidingObject = (PDrawableObject *) aCollidingObjects.GetAt(i);
			if(pCollidingObject ->GetObjectType() == OBJ_TYPE_POKEMON) collide = true;
			tmpx=loc.x;
			tmpy=loc.y;
			tmpz=loc.z;
			loc.x=newx;
			loc.y=newy;
			loc.z=newz;
			pCollidingObject ->HandleCollision(this);
			HandleCollision(pCollidingObject);
			loc.x=tmpx;
			loc.y=tmpy;
			loc.z=tmpz;
			if(this->GetObjectType()!=OBJ_TYPE_POKEMON /*&& pCollidingObject->GetObjectType()!=OBJ_TYPE_POKEMON*/)
				collide=false;
		}
	}

	if(!collide) {
		loc.x = newx;
		loc.y = newy;
		loc.z = newz;
		if(groundBound && mcMove != MC_MOVE_FALL) {
			ry = newry;
			pDirection = pDirection2D;
			pDirection.Rotate(AXIS_Y, ry);
			rx = newrx;
			pDirection.Rotate(AXIS_X, rx);
		}
	}

	if(pGame->GetStage()==1 && this->GetObjectType()==OBJ_TYPE_POKEMON) {
		PTrackParticle *pTrack=new PTrackParticle(pGame, this);
		pGame->AddObject(pTrack);
	}

	// reset bound volume coordinates
	pVolume.SetCoordinates(loc.x,loc.y,loc.z);
	pVolume.SetRotation(rx,ry,rz);
}

void PMovableObject::Rotate(AXIS axis, float fAngle)
{
	pDirection.Rotate(axis, fAngle);
	if(axis == AXIS_Z) pDirection2D.Rotate(AXIS_Z, fAngle);

	PDrawableObject::Rotate(axis, fAngle);

}

// returns the x,y orientation of the object
float PMovableObject::GetDirection()
{
	return rz;
}

void PMovableObject::RotateToCamera() {
	PMovableObject *pObject=(PMovableObject *)pGame->GetFocusObject();
	glRotatef(-(pObject->GetDirection()),0.0,0.0,1.0);
}

void PMovableObject::SetVelocity(float fVelocity)
{
	this ->fVelocity = fVelocity;
}

PVector PMovableObject::GetDirectionVector()
{
	return pDirection;
}

void PMovableObject::SetDirection(PVector *v)
{
	pDirection.set(v ->x, v ->y, v ->z);
}
