// PMoat.cpp: implementation of the PMoat class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "math.h"
#include <gl\gl.h>			// Header File For The OpenGL32 Library
#include "PGame.h"
#include "PMoat.h"
#include "PRainParticle.h"
#include "PSnowParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/* PMoat Constructor
 * ------------------
 * Constructor for PMoat.
 */
PMoat::PMoat(PGame *pGame, int xWidth, int yLength, int skyWidth, int skyLength)
{
	this->pGame = pGame;
	this->xWidth = xWidth;
	this->yLength = yLength;
	this->skyWidth = skyWidth;
	this->skyLength = skyLength;
}

/* PMoat Destructor
 * ------------------
 * Destructor for PMoat.
 */
PMoat::~PMoat()
{

}

/* DrawMoat
 * ------------------
 * Draws the Moat and the area of water on the terrain.
 */
void PMoat::DrawMoat(float anim) {
	int eastEdge, westEdge, northEdge, southEdge, i, j;
	float r;

	westEdge = (int)floor(((float)(skyWidth - xWidth))/2.0);
	eastEdge = (int)ceil(((float)(skyWidth - xWidth))/2.0);
	northEdge = (int)ceil(((float)(skyLength - yLength))/2.0);
	southEdge = (int)floor(((float)(skyLength - yLength))/2.0);


	for (i = yLength - 1; i <= yLength + westEdge; i++) {
		for (j = -southEdge; j <= xWidth + northEdge; j++) {
			if (pGame->ground->moatDraw[i + eastEdge][j + southEdge]) {
				r=rand()%100;
				if(pGame->GetStage()==1 && r==0.0) {
					PSnowParticle *pSnow=new PSnowParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pSnow);
				}
				if(pGame->GetStage()==3 && r==0.0) {
					PRainParticle *pRain=new PRainParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pRain);
				}
				glBegin(GL_QUADS);
					glTexCoord2d(anim+0.0f,anim+0.0f);
					glVertex3f((float)(i),(float)(j),0.0f);
					glTexCoord2d(anim+1.0f,anim+0.0f);
					glVertex3f((float)(i + 1),(float)(j),0.0f);
					glTexCoord2d(anim+1.0f,anim+1.0f);
					glVertex3f((float)(i + 1),(float)(j + 1),0.0f);
					glTexCoord2d(anim+0.0f,anim+1.0f);
					glVertex3f((float)(i),(float)(j + 1),0.0f);
				glEnd();			
			}
		}
	}

	for (i = -eastEdge; i < 0; i++) {
		for (j = -southEdge; j <= xWidth + northEdge; j++) {
			glBegin(GL_QUADS);
			if (pGame->ground->moatDraw[i + eastEdge][j + southEdge]) {
				r=rand()%100;
				if(pGame->GetStage()==1 && r==0.0) {
					PSnowParticle *pSnow=new PSnowParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pSnow);
				}
				if(pGame->GetStage()==3 && r==0.0) {
					PRainParticle *pRain=new PRainParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pRain);
				}
				glTexCoord2d(anim+0.0f,anim+0.0f);
				glVertex3f((float)(i),(float)(j),0.0f);
				glTexCoord2d(anim+1.0f,anim+0.0f);
				glVertex3f((float)(i + 1),(float)(j),0.0f);
				glTexCoord2d(anim+1.0f,anim+1.0f);
				glVertex3f((float)(i + 1),(float)(j + 1),0.0f);
				glTexCoord2d(anim+0.0f,anim+1.0f);
				glVertex3f((float)(i),(float)(j + 1),0.0f);
			glEnd();			
			}
		}
	}

	for (i = 0; i < yLength - 1; i++) {
		for (j = -southEdge; j < 0; j++) {
			if (pGame->ground->moatDraw[i + eastEdge][j + southEdge]) {
				r=rand()%100;
				if(pGame->GetStage()==1 && r==0.0) {
					PSnowParticle *pSnow=new PSnowParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pSnow);
				}
				if(pGame->GetStage()==3 && r==0.0) {
					PRainParticle *pRain=new PRainParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pRain);
				}
			glBegin(GL_QUADS);	
				glTexCoord2d(anim+0.0f,anim+0.0f);
				glVertex3f((float)(i),(float)(j),0.0f);
				glTexCoord2d(anim+1.0f,anim+0.0f);
				glVertex3f((float)(i + 1),(float)(j),0.0f);
				glTexCoord2d(anim+1.0f,anim+1.0f);
				glVertex3f((float)(i + 1),(float)(j + 1),0.0f);
				glTexCoord2d(anim+0.0f,anim+1.0f);
				glVertex3f((float)(i),(float)(j + 1),0.0f);
			glEnd();			
			}
		}
	}

	for (i = 0; i < yLength - 1; i++) {
		for (j = xWidth - 1; j <= xWidth + northEdge; j++) {
			if (pGame->ground->moatDraw[i + eastEdge][j + southEdge]) {	
				r=rand()%100;
				if(pGame->GetStage()==1 && r==0.0) {
					PSnowParticle *pSnow=new PSnowParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pSnow);
				}
				if(pGame->GetStage()==3 && r==0.0) {
					PRainParticle *pRain=new PRainParticle(pGame, this, i, j, 8.0);
					pGame->AddObject(pRain);
				}
			glBegin(GL_QUADS);	
				glTexCoord2d(anim+0.0f,anim+0.0f);
				glVertex3f((float)(i),(float)(j),0.0f);
				glTexCoord2d(anim+1.0f,anim+0.0f);
				glVertex3f((float)(i + 1),(float)(j),0.0f);
				glTexCoord2d(anim+1.0f,anim+1.0f);
				glVertex3f((float)(i + 1),(float)(j + 1),0.0f);
				glTexCoord2d(anim+0.0f,anim+1.0f);
				glVertex3f((float)(i),(float)(j + 1),0.0f);
			glEnd();			
			}
		}
	}

	/*glDisable(GL_LIGHTING);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	if(pGame->GetStage()==1) glColor4f(1.0,1.0,1.0,1.0);*/
	for (i = 0; i < yLength - 1; i++) {
		for (j = 0; j < xWidth - 1; j++) {
			int counter = 0;
			if (pGame->ground->moatLand[i][j]) {counter++;}
			if (pGame->ground->moatLand[i+1][j]) {counter++;}
			if (pGame->ground->moatLand[i][j+1]) {counter++;}
			if (pGame->ground->moatLand[i+1][j+1]) {counter++;}
			if (counter == 2 || counter == 3 || counter ==4) {
				glBegin(GL_QUADS);	
					glTexCoord2d(anim+0.0f,anim+0.0f);
					glVertex3f((float)(i),(float)(j),pGame->ground->map[i][j]);
					glTexCoord2d(anim+1.0f,anim+0.0f);
					glVertex3f((float)(i + 1),(float)(j),pGame->ground->map[i+1][j]);
					glTexCoord2d(anim+1.0f,anim+1.0f);
					glVertex3f((float)(i+1),(float)(j+1),pGame->ground->map[i+1][j+1]);
					glTexCoord2d(anim+0.0f,anim+1.0f);
					glVertex3f((float)(i),(float)(j+1), pGame->ground->map[i][j+1]);
					glEnd();			
			}
			else if (pGame->ground->moatLand[i][j]) {
				glBegin(GL_TRIANGLES);	
					glTexCoord2d(anim+0.0f,anim+0.0f);
					glVertex3f((float)(i),(float)(j),pGame->ground->map[i][j]);
					glTexCoord2d(anim+1.0f,anim+0.0f);
					glVertex3f((float)(i+1),(float)(j),pGame->ground->map[i+1][j]);
					glTexCoord2d(anim+0.0f,anim+1.0f);
					glVertex3f((float)(i),(float)(j+1),pGame->ground->map[i][j+1]);
				glEnd();
			}
			else if (pGame->ground->moatLand[i][j+1]) {
				glBegin(GL_TRIANGLES);	
					glTexCoord2d(anim+0.0f,anim+1.0f);
					glVertex3f((float)(i),(float)(j+1),
								pGame->ground->map[i][j+1]);
					glTexCoord2d(anim+0.0f,anim+0.0f);
					glVertex3f((float)(i),(float)(j),pGame->ground->map[i][j]);
					glTexCoord2d(anim+1.0f,anim+1.0f);
					glVertex3f((float)(i+1),(float)(j+1),pGame->ground->map[i+1][j+1]);
				glEnd();
			}
			else if (pGame->ground->moatLand[i+1][j]) {
				glBegin(GL_TRIANGLES);	
					glTexCoord2d(anim+1.0f,anim+0.0f);
					glVertex3f((float)(i+1),(float)(j),
								pGame->ground->map[i+1][j]);
					glTexCoord2d(anim+1.0f,anim+1.0f);
					glVertex3f((float)(i+1),(float)(j+1),
								pGame->ground->map[i+1][j+1]);
					glTexCoord2d(anim+0.0f,anim+0.0f);
					glVertex3f((float)(i),(float)(j),pGame->ground->map[i][j]);
				glEnd();					
			}
			else if (pGame->ground->moatLand[i+1][j+1]) {
				glBegin(GL_TRIANGLES);	
					glTexCoord2d(anim+1.0f,anim+1.0f);
					glVertex3f((float)(i+1),(float)(j+1),pGame->ground->map[i+1][j+1]);
					glTexCoord2d(anim+0.0f,anim+1.0f);
					glVertex3f((float)(i),(float)(j+1),pGame->ground->map[i][j+1]);
					glTexCoord2d(anim+1.0f,anim+0.0f);
					glVertex3f((float)(i+1),(float)(j),pGame->ground->map[i+1][j]);
				glEnd();					
			}
		}
	}
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
}

/* Draw
 * ------------------
 * Sets various values and calls DrawMoat.
 */
void PMoat::Draw()
{
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);

	GLfloat mat_diffuse[] = { 1.0f, 1.0, 1.0, 1.0 };
	GLfloat mat_specular[]={1.0,1.0,1.0,1.0};
	GLfloat low_shininess[]={128.0};

	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, low_shininess);


	//determines which texture to map according to which stage it is
	if(pGame->GetStage()==0) {
		glBindTexture(GL_TEXTURE_2D, textures[43]);
		DrawMoat(0);
	} else if(pGame->GetStage()==1) {
		glBindTexture(GL_TEXTURE_2D, textures[46]);
		DrawMoat(0);
	} else if(pGame->GetStage()==2) {
		glBindTexture(GL_TEXTURE_2D, textures[49]);
		DrawMoat(0);
	} else if(pGame->GetStage()==3) {
		glBindTexture(GL_TEXTURE_2D, textures[56]);
		DrawMoat(0);
	}

	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
}

/* Set(Variable)
 * ------------------
 * Sets various variables.
 */
void PMoat::SetXWidth (int xWidth)
{
	this->xWidth = xWidth;
}

void PMoat::SetYLength (int yLength)
{
	this->yLength = yLength;
}

void PMoat::SetSkyWidth (int skyWidth)
{
	this->skyWidth = skyWidth;
}

void PMoat::SetSkyLength (int skyLength)
{
	this->skyLength = skyLength;
}

/* Get(Variable)
 * ------------------
 * Returns various variables.
 */
int PMoat::GetXWidth(void)
{
	return (xWidth);
}

int PMoat::GetYLength(void)
{
	return (yLength);
}

int PMoat::GetSkyWidth(void)
{
	return (skyWidth);
}

int PMoat::GetSkyLength(void)
{
	return (skyLength);
}
