// PLightnParticle.cpp: implementation of the PLightnParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PPokemon.h"
#include "PLightnParticle.h"
#include "PSmokeParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define LIGHT_PARTS 25

void makeLight(float x, float y, float z);

PLightnParticle::PLightnParticle(PGame *pGame, PDrawableObject *pSource, ATTACK_CODE acAttack):
	PParticle(pGame,pSource)
	{
	fDistance = .5;
	fVelocity = 10.0f;
	this ->pGame = pGame;
	this->pSource=pSource;
	this->acAttack=acAttack;
	width = 0.75f;
	length = 0.5f;
	height = 0.75f;
	denomx=400.0;
	denomy=700.0;
	denomz=700.0;
	loc.x=pSource->GetCoordinate(AXIS_X);
	loc.y=pSource->GetCoordinate(AXIS_Y);
	loc.z=pSource->GetCoordinate(AXIS_Z);
	if(pGame->GetGameOption(GO_SOUND)==1) {
		PSound *pSound=pGame->GetSoundObject();
		pSound->PlaySound(SOUND_THU, false,this->Distance(pGame->GetFocusObject()));
	}
	if(acAttack==AC_NORMAL_ATTACK) {
		lifetime=1.0;
		fVelocity = 10.0f;
		pVolume.SetDimensions(width, length, height);
	} else if(acAttack==AC_CLOSE_ATTACK) {
		width=height=.5;
		length=1.0;
		lifetime=.25;
		fDistance=0.0;
		fVelocity=5.0;
		//this->SetCoordinates(pSource->GetCoordinate(AXIS_X),pSource->GetCoordinate(AXIS_Y),pSource->GetCoordinate(AXIS_Z));
		pVolume.SetDimensions(width, length,height);
	}

}

PLightnParticle::~PLightnParticle()
{

}

/* draws a lightning particle */

void PLightnParticle::makeLight(float x, float y, float z) {
	glBegin(GL_TRIANGLE_STRIP);
		glVertex3f(x-.05,y-.05,z-.05);
		glVertex3f(x-.05,y+.05,z-.05);
		glVertex3f(x+.05,y+.05,z+.05);
		glVertex3f(x+.05,y-.05,z+.05);
	glEnd();
}

/* draws the lightning particles */

void PLightnParticle::Draw()
{

	glTranslatef(0.0f, 0.0f, 0.1f);
	glDisable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_TEXTURE_2D);

	if(loc.z + 0.1f<pGame->ground->GetHeight(loc.x,loc.y) && acAttack==AC_NORMAL_ATTACK) {
		active=false;
		PSmokeParticle *pSmoke=new PSmokeParticle(pGame,pGame->ground);
		pSmoke ->SetCoordinates(loc.x, loc.y, .02+ pGame->ground->GetHeight(loc.x, loc.y) );
		pSmoke ->Rotate(AXIS_Z, rz);
		pGame ->AddObject(pSmoke);
	}

	if(acAttack==AC_NORMAL_ATTACK) {
		glBindTexture(GL_TEXTURE_2D, textures[44]); 
		glColor3ub(255, 255, 0); 
		glRotatef(90, 0, 0, 1);		

		glBegin(GL_QUADS);

			glTexCoord2f(0,0);
			glVertex3f(-width * 0.5f, 0, -width * 0.5f);
			
			glTexCoord2f(1,0);
			glVertex3f(width * 0.5f, 0, - width * 0.5f);
			
			glTexCoord2f(1,1);
			glVertex3f(width * 0.5f, 0, width * 0.5f);
			
			glTexCoord2f(0,1);
			glVertex3f(-width * 0.5f, 0, width * 0.5f);

					
		glEnd(); 
	}
	glBindTexture(GL_TEXTURE_2D, textures[45]); 
	glColor3ub(255, 255, 0); 
	
	glRotatef(rand()%180, 1, 0, 0);

	glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex3f(-width * 0.5f, 0, -width * 0.5f);
			
		glTexCoord2f(1,0);
		glVertex3f(width * 0.5f, 0, - width * 0.5f);
			
		glTexCoord2f(1,1);
		glVertex3f(width * 0.5f, 0, width * 0.5f);
			
		glTexCoord2f(0,1);
		glVertex3f(-width * 0.5f, 0, width * 0.5f);
				
	glEnd();
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
}

/* moves the lightning according to which attack it is */

void PLightnParticle::Move(MOVE_CODE mcMove)
{
	if(acAttack==AC_NORMAL_ATTACK) {
		PProjectile::Move(mcMove);
		fDistance += fVelocity * pGame ->GetTimeElapsed();
	} else if(acAttack==AC_CLOSE_ATTACK) {
		PProjectile::Move(MC_MOVE_SURROUND);
		denomx-=100.0;
		denomy-=100.0;
		denomz-=100.0;
		if(denomx<=0) denomx=100.0;
		if(denomy<=0) denomy=100.0;
		if(denomz<=0) denomz=100.0;
		width+=.3;
		height+=.3;
		length+=.3;
		pVolume.SetDimensions(width, length, height);
		this->SetCoordinates(pSource->GetCoordinate(AXIS_X),pSource->GetCoordinate(AXIS_Y),pSource->GetCoordinate(AXIS_Z));
	}
	lifetime-=.05;
	if((fDistance > 10.0 && acAttack==AC_NORMAL_ATTACK) || (lifetime<0.0 && acAttack==AC_CLOSE_ATTACK) || !active) {
		pGame ->RemoveObject(this);
	}
}

/* handles the collision between pikachu's attack and a pokemon */

void PLightnParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	if(pObjectCollidedWith ->GetObjectType() == OBJ_TYPE_POKEMON) {
		PPokemon * pTarget = (PPokemon *) pObjectCollidedWith;
		if(pTarget!=pSource && !pTarget ->IsBlocking()) {
			int iDamage;
			PVector tVector,cVector;
			float x,y,z;

			if(acAttack==AC_NORMAL_ATTACK) {
				x=loc.x+pDirection.getX();
				y=loc.y+pDirection.getY();
			} else if(acAttack==AC_CLOSE_ATTACK) {
				cVector=this->GetCoordinates();
				cVector.subtract(&pTarget->GetCoordinates());
				cVector.multiply(1.5);
				cVector.invert();
				x=loc.x+cVector.getX();
				y=loc.y+cVector.getY();
			}

			if(x>=(float)pGame->ground->GetXWidth()-1) x=(float)pGame->ground->GetXWidth()-1;
			if(x<=0) x=0;
			if(y>=(float)pGame->ground->GetYLength()-1) y=(float)(float)pGame->ground->GetYLength()-1;
			if(y<=0) y=0;
			z=pGame->ground->GetHeight(x,y);
			//if(z<0) z=0;
			//printf("z:%f\n",z);

			tVector=PVector(x,y,z);

			CPtrArray aCollidingObjects;

			pGame ->DetectCollisions(pTarget, pTarget->GetBoundVolume(), & aCollidingObjects);

			PDrawableObject * pCollidingObject;
			for(int i=0; i<aCollidingObjects.GetSize(); i++) {
				pCollidingObject=(PDrawableObject *) aCollidingObjects.GetAt(i);
				if(pCollidingObject->GetObjectType()==OBJ_TYPE_POKEMON && pCollidingObject!=pTarget) return;
			}

			if(pSource ->GetObjectType() == OBJ_TYPE_POKEMON) {
				 int iAttack = ((PPokemon *) pSource) ->GetStat(PS_ATTACK) * 0.25f;
				 iDamage = iAttack + rand() % iAttack;
			} else {
				iDamage = 10;
			}
			if(acAttack==AC_NORMAL_ATTACK) pTarget ->TakeDamage(DT_LIGHTNING, iDamage);
			else if(acAttack==AC_CLOSE_ATTACK) pTarget ->TakeDamage(DT_LIGHTNING, iDamage * 2);
			pTarget->SetCoordinates(tVector.getX(),tVector.getY(),tVector.getZ());
			pGame ->RemoveObject(this);
		}
	}
}
