// PLavaParticle.cpp: implementation of the PLavaParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PLavaParticle.h"
#include "PPokemon.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//#define LAVA_PARTS 15

void makeLava(float x, float y, float z);

PLavaParticle::PLavaParticle(PGame *pGame, PDrawableObject *pSource, float x, float y, float z):
	PParticle(pGame,pSource)
{
	pDirection.set(0.0,0.0,0.0);
	lifetime=5.0;
	groundBound=true;
	fDistance = 0.0f;
	fVelocity =.5f;
	this ->pGame = pGame;
	this->pSource=pSource;
	width = 0.3f;
	length = 0.3f;
	height = 0.3f;
	loc.x=x;
	loc.y=y;
	loc.z=z;

	for(int i=0;i<LAVA_PARTS;i++) {
		r[i]=(float)(rand()%100)/300.0;
		r1[i]=(float)(rand()%100)/300.0;

		if(rand()%2==0) r[i]=-r[i];
		if(rand()%2==0) r1[i]=-r1[i];
	}

	if(pGame->GetGameOption(GO_SOUND)==1) {
		float dist=this->Distance(pGame->GetFocusObject());
		PSound *pSound=pGame->GetSoundObject();
		pSound->ChangeVolume(SOUND_LAVA,dist);
	}
	pVolume.SetDimensions(width, length, height);
}

PLavaParticle::~PLavaParticle()
{

}

/* draws a lava particle */

void PLavaParticle::makeLava(float x, float y, float z) {

	glBegin(GL_POLYGON);
		glTexCoord2f(0,0);
		glVertex3f(x+.08,y,z+.01);
		glTexCoord2f(1,1);
		glVertex3f(x+.06,y+.06,z+.02);
		glVertex3f(x,y+.1,z+.01);
		glTexCoord2f(0,1);
		glVertex3f(x-.06,y+.06,z+.02);
		glVertex3f(x-.08,y,z+.01);
		glTexCoord2f(0,0);
		glVertex3f(x-.06,y-.06,z+.02);
		glVertex3f(x,y-.1,z+.01);
		glTexCoord2f(0,0);
		glVertex3f(x+.06,y-.06,z+.02);
	glEnd();
}

/* draws the lava particles */

void PLavaParticle::Draw()
{
	glDisable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, textures[49]); 
	glColor3ub(255, 55, 55); 
	glRotatef(ry, 0, 1, 0);
	glRotatef(rx,1,0,0);

	for(int i=0;i<LAVA_PARTS;i++) {

		makeLava(r[i],r1[i],0);
	}

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
}

/* moves the lava */

void PLavaParticle::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(MC_MOVE_DOWN);
	PVector pt=this->GetCoordinates();
	if((double)(pGame->ground->GetXWidth() - 1) < pt.x ||
		(double)(pGame->ground->GetYLength() - 1) < pt.y || pt.x<0 || pt.y<0)
		pGame->RemoveObject(this);
	fDistance += fVelocity * pGame ->GetTimeElapsed();
	lifetime-=pGame->GetTimeElapsed();
	if(fDistance>2.0  || lifetime<0.0) {
		pGame ->RemoveObject(this);
	}
}

/* handles the collision between lava and pokemon - pushes pokemon around */

void PLavaParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	if(pObjectCollidedWith ->GetObjectType() == OBJ_TYPE_POKEMON) {
		PPokemon * pTarget = (PPokemon *) pObjectCollidedWith;
		if(pTarget!=pSource) //pTarget->SetVelocity(pTarget->GetVelocity()-fVelocity);
		{
			float iDamage;
			PVector tVector,cVector;
			float x,y,z;
			x=loc.x+pDirection.getX();
			y=loc.y+pDirection.getY();
			z=pGame->ground->GetHeight(x,y);
			if(x>(float)pGame->ground->GetXWidth()-1) x=(float)pGame->ground->GetXWidth()-1;
			if(x<0) x=0;
			if(y>(float)pGame->ground->GetYLength()-1) y=(float)(float)pGame->ground->GetYLength()-1;
			if(y<0) y=0;

			tVector=PVector(x,y,z);

			CPtrArray aCollidingObjects;

			pGame ->DetectCollisions(pTarget, pTarget->GetBoundVolume(), & aCollidingObjects);

			PDrawableObject * pCollidingObject;
			for(int i=0; i<aCollidingObjects.GetSize(); i++) {
				pCollidingObject=(PDrawableObject *) aCollidingObjects.GetAt(i);
				if(pCollidingObject->GetObjectType()==OBJ_TYPE_POKEMON && pCollidingObject!=pTarget) return;
			}

			if(pTarget->GetPokemonType()==PT_PIKACHU || pTarget->GetPokemonType()==PT_SQUIRTLE) {
				iDamage=.07;
				if(pTarget->GetPokemonType()==PT_SQUIRTLE) iDamage*=2;
				pTarget->TakeDamage(DT_NORMAL,iDamage);
			}

			if(loc.z<z) return;
			pTarget->SetCoordinates(x,y,z);
			pGame->RemoveObject(this);
		}
	}
}
