// PGame.h: interface for the PGame class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PGAME_H__3D35DB76_3086_4FBE_BD2F_76BEE51D08C1__INCLUDED_)
#define AFX_PGAME_H__3D35DB76_3086_4FBE_BD2F_76BEE51D08C1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PObject.h"
#include "PDrawableObject.h"
#include "time.h"
#include "PSound.h"
#include "PTerrain.h"
#include "MD2.h"
#include "PFrustumCuller.h"
#include "defines.h"	// Added by ClassView


class PGame : public PObject  
{
public:
	void Save();
	void SetCharacter(POKEMON_STAT stat, int value);

	AI_MOVE GuessMove();
	void EvaluateAI(AI_MOVE aiMove);
	void ToggleLearning();
	
	float GetTimeElapsed();
	GAME_STATE GetGameState();
	int GetTimer();
	void StartTimer();
	void CheckGameStatus();
	void DetectCollisions(PDrawableObject * pObject, PBoundVolume * pVolume, CPtrArray * pCollidingObjects);
	void StartGame();
	void StopGame();
	void QuitGame();

	SetGameOption(GAME_OPTION goOption, int val);
	int GetGameOption(GAME_OPTION goOption);
	int GetStage();

	void SetGameState(GAME_STATE gsState);
	
	void Draw();
	void ResizeWindow(int w, int h);
	void Keyboard(unsigned char key, int x, int y);
	void KeyboardUp(unsigned char key, int x, int y);
	
	PSound *GetSoundObject();
	PDrawableObject *GetFocusObject();

	void AddObject(PDrawableObject * pObject);
	void RemoveObject(PDrawableObject * pObject);
	CPtrArray * GetObjects(OBJECT_TYPE ocType);

	PGame();
	virtual ~PGame();

	PTerrain *ground;
	PFrustumCuller* culler;
protected:
	CPtrArray aEnvironmentObjects;
	void EmptyGarbage();
	void CleanUp();
	void UpdateGameState();
	
	struct GameOptions{
		int difficulty;
		int numEnemies;
		int sound;
		int lastLevel;
	} goOptions;

	struct CharacterStats {
		int character;
		int level;
		int experience;
		int next;
		int hp;
		int attack;
		int speed;
	} csStats;

	void SetUpMenus();

	void SetUpThreads();

	int w, h;

	CPtrArray aGarbage;
	CPtrArray aWorldObjects;
	CPtrArray aProjectiles;
	CPtrArray aPokemon;
	GAME_STATE gsState;
	clock_t countStart;
	clock_t tLast;
	int stage;
	float fTimeElapsed;
	bool bGameOn;
};

#endif // !defined(AFX_PGAME_H__3D35DB76_3086_4FBE_BD2F_76BEE51D08C1__INCLUDED_)
