/* PFrustumCuller.h: header for PFrustumCuller class
 */
#ifndef _pfrustumculler_
#define _pfrustumculler_

#include "PBoundVolume.h"
#include "PTerrain.h"
#include "PSkyBox.h"
#include "PDrawableObject.h"

class CollisionNode : public PObject
{
protected:
	PBoundVolume* bound;
	CollisionNode* leftNorthChild;
	CollisionNode* rightNorthChild;
	CollisionNode* leftSouthChild;
	CollisionNode* rightSouthChild;

public:
	CollisionNode() {bound = NULL; leftNorthChild = NULL; rightNorthChild = NULL;
					leftSouthChild = NULL; rightSouthChild = NULL;}
	~CollisionNode();
};

class ItemNode : public PObject
{
public:
	PDrawableObject* item;
	ItemNode* next;
	ItemNode(PDrawableObject* node) {item = node; next = NULL;}
	~ItemNode() {}
};

class PFrustumCuller : public PObject
{
public:
	PFrustumCuller();
	~PFrustumCuller();
	void AddToFrustum(PDrawableObject* item, int toggle);
	void DrawDecision(void);

protected:
	void GetFrustumPlanes(void);
	int BoxInFrustum(float x, float y, float z, float length, float width, float height);
/*	void MakeTerrainTree (terrainTree, cellBound);*/
	float frustum [6][4];
	CollisionNode* terrainTree;
	PTerrain* ground;
	PSkyBox* skyBox;
	ItemNode* items;
};
#endif