/* PFrustumCuller.cpp: implementation for PFrustumCuller class
 */

#include "stdafx.h"
#include "PFrustumCuller.h"
#include "PDrawableObject.h"
#include "PBoundVolume.h"
#include "pvector.h"
//#include "PTerrain.h"

/* PFrustumCuller Constructor
 * --------------------------
 * Sets items to NULL.
 */
PFrustumCuller::PFrustumCuller()
{
	items = NULL;
}

/* PFrustumCuller Destructor
 * -------------------------
 * Destructor for PFrustumCuller.
 */
PFrustumCuller::~PFrustumCuller()
{

}

/* AddToFrustum
 * --------------------
 * Adds an object to the PFrustumCuller class so that it can keep track of what to check
 * for frustum culling.
 */
void PFrustumCuller::AddToFrustum(PDrawableObject* item, int toggle)
{
	if (toggle == 1) {
		this->ground = (PTerrain*) item;
/*		PTerrain* ground = (PTerrain*)item;
		PBoundVolume* cellBound = new PBoundVolume();
		SetDimensions((ground->xWidth - 1)/(ground->LOD), (ground->yLength - 1)/(ground->LOD), 
					  ground->maxHeight * 2);
		SetCoordinates((ground->xWidth - 1)/(ground->LOD * 2), 
					   (ground->yLength - 1)/(ground->LOD * 2), 0);
		MakeTerrainTree (terrainTree, cellBound);*/
	}
	else if (toggle == 2) {
		this->skyBox = (PSkyBox*) item;
	}
	else {
		ItemNode* temp = items;
		items = new ItemNode(item);
		items->next = temp;
	}
}

/*
void MakeTerraintree (CollisionNode* tTree, PBoundVolume* cellBound) {
	if (cellBound->hu >= 2 && cellBound->hv >= 2) {
		tTree = new CollisionNode();
		PBoundVolume* bound = new PBoundVolume();
		SetDimensions(floor(cellBound->hu), floor(cellBound->hv), 
					  ground->maxHeight * 2);
		SetCoordinates((cellBound->x), 
					   (ground->yLength - 1)/(ground->LOD * 2), 0);
		MakeTerrainTree (tTree->leftSouthChild, bound);		
	}
	else {
		tTree = NULL;
	}
}
*/

/* DrawDecision
 * ------------------
 * Called to Decide what should be culled and what should not.
 */
void PFrustumCuller::DrawDecision()
{
	int i, j, temp;
	float xCenter, yCenter, zCenter, xLen, yLen, zLen, LOD;
	ItemNode* next = items;
	PBoundVolume* bounds;

	GetFrustumPlanes();
	while (next != NULL) {
		bounds = next->item->GetBoundVolume();
		xCenter = bounds->x; /*+ next->item->GetCoordinates().getX();*/
		yCenter = bounds->y; /*+ next->item->GetCoordinates().getY();*/
		zCenter = bounds->z; /*+ next->item->GetCoordinates().getZ();*/
		xLen = bounds->hu;
		yLen = bounds->hv;
		zLen = bounds->hw;
		temp = BoxInFrustum(xCenter, yCenter, zCenter, xLen, yLen, zLen);
		if (temp == 0) {
			next->item->shouldDraw = false;
		}
		else {
			next->item->shouldDraw = true;
		}
		next = next->next;
	}
	LOD = (float)(ground->GetLOD());
	for (i = 0; i < ground->GetXWidth() - 1; i++) {
		for (j = 0; j < ground->GetYLength() - 1; j++) {
			xCenter = (1/(2 * LOD)) + (float)(i/LOD);
			yCenter = (1/(2 * LOD)) + (float)(j/LOD);
			zCenter = 0;
			xLen = 0.5/LOD;
			yLen = 0.5/LOD;
			zLen = ground->GetMaxHeight();
			temp = BoxInFrustum(xCenter, yCenter, zCenter, xLen, yLen, zLen);
			if (temp == 0) {
				(ground->mapDraw)[i][j] = false;
			}
			else {
				(ground->mapDraw)[i][j] = true;
			}
		}
	}
	int yShift = (int)floor(((float)(ground->skyBox->GetSkyLength() - 
								ground->GetYLength()))/2.0);
	int xShift = (int)ceil(((float)(ground->skyBox->GetSkyWidth() - 
								ground->GetXWidth()))/2.0);

	for (i = 0; i < ground->skyBox->GetSkyWidth() + 1; i++) {
		for (j = 0; j < ground->skyBox->GetSkyLength() + 1; j++) {
			if (!(i >= xShift && i < ground->GetXWidth()  && j >= yShift && 
					j < ground->GetYLength())) {
				xCenter = 0.5 + (float)(i) - xShift;
				yCenter = 0.5 + (float)(j) - yShift;
				zCenter = 0.1;
				xLen = 0.5;
				yLen = 0.5;
				zLen = 0.1;
				temp = BoxInFrustum(xCenter, yCenter, zCenter, xLen, yLen, zLen);
				if (temp == 0) {
					(ground->moatDraw)[i][j] = false;
				}
				else {
					(ground->moatDraw)[i][j] = true;
				}
			}	
		}
	}

}

/* BoxInFrustum
 * ------------------
 * Called to see if a box is within the frustum, intersects the frustum bounds, or is 
 * completely outside of the bounds.  Partially derived from code from frustum culling
 * tutorial at http://www.markmorley.com/opengl/frustumculling.html
 */
int PFrustumCuller::BoxInFrustum(float x, float y, float z, float length, float width, float height)
{
   int p;
   int c;
   int c2 = 0;

   for( p = 0; p < 6; p++ )
   {
      c = 0;
      if( frustum[p][0] * (x - length) + frustum[p][1] * (y - width) + frustum[p][2] * (z - height) + frustum[p][3] > 0 )
         c++;
      if( frustum[p][0] * (x + length) + frustum[p][1] * (y - width) + frustum[p][2] * (z - height) + frustum[p][3] > 0 )
         c++;
      if( frustum[p][0] * (x - length) + frustum[p][1] * (y + width) + frustum[p][2] * (z - height) + frustum[p][3] > 0 )
         c++;
      if( frustum[p][0] * (x + length) + frustum[p][1] * (y + width) + frustum[p][2] * (z - height) + frustum[p][3] > 0 )
         c++;
      if( frustum[p][0] * (x - length) + frustum[p][1] * (y - width) + frustum[p][2] * (z + height) + frustum[p][3] > 0 )
         c++;
      if( frustum[p][0] * (x + length) + frustum[p][1] * (y - width) + frustum[p][2] * (z + height) + frustum[p][3] > 0 )
         c++;
      if( frustum[p][0] * (x - length) + frustum[p][1] * (y + width) + frustum[p][2] * (z + height) + frustum[p][3] > 0 )
         c++;
      if( frustum[p][0] * (x + length) + frustum[p][1] * (y + width) + frustum[p][2] * (z + height) + frustum[p][3] > 0 )
         c++;
      if( c == 0 )
         return 0;
      if( c == 8 )
         c2++;
   }
   return (c2 == 6) ? 2 : 1;
}

/* GetFrustumPlanes
 * ------------------
 * Called to find the frustum bounding planes. Partially derived from code from frustum 
 * culling tutorial at http://www.markmorley.com/opengl/frustumculling.html
 */
void PFrustumCuller::GetFrustumPlanes()
{
   float   proj[16];
   float   modl[16];
   float   clip[16];
   float   t;

   /* Get the current PROJECTION matrix from OpenGL */
   glGetFloatv( GL_PROJECTION_MATRIX, proj );

   /* Get the current MODELVIEW matrix from OpenGL */
   glGetFloatv( GL_MODELVIEW_MATRIX, modl );

   /* Combine the two matrices (multiply projection by modelview) */
   clip[ 0] = modl[ 0] * proj[ 0] + modl[ 1] * proj[ 4] + modl[ 2] * proj[ 8] + modl[ 3] * proj[12];
   clip[ 1] = modl[ 0] * proj[ 1] + modl[ 1] * proj[ 5] + modl[ 2] * proj[ 9] + modl[ 3] * proj[13];
   clip[ 2] = modl[ 0] * proj[ 2] + modl[ 1] * proj[ 6] + modl[ 2] * proj[10] + modl[ 3] * proj[14];
   clip[ 3] = modl[ 0] * proj[ 3] + modl[ 1] * proj[ 7] + modl[ 2] * proj[11] + modl[ 3] * proj[15];

   clip[ 4] = modl[ 4] * proj[ 0] + modl[ 5] * proj[ 4] + modl[ 6] * proj[ 8] + modl[ 7] * proj[12];
   clip[ 5] = modl[ 4] * proj[ 1] + modl[ 5] * proj[ 5] + modl[ 6] * proj[ 9] + modl[ 7] * proj[13];
   clip[ 6] = modl[ 4] * proj[ 2] + modl[ 5] * proj[ 6] + modl[ 6] * proj[10] + modl[ 7] * proj[14];
   clip[ 7] = modl[ 4] * proj[ 3] + modl[ 5] * proj[ 7] + modl[ 6] * proj[11] + modl[ 7] * proj[15];

   clip[ 8] = modl[ 8] * proj[ 0] + modl[ 9] * proj[ 4] + modl[10] * proj[ 8] + modl[11] * proj[12];
   clip[ 9] = modl[ 8] * proj[ 1] + modl[ 9] * proj[ 5] + modl[10] * proj[ 9] + modl[11] * proj[13];
   clip[10] = modl[ 8] * proj[ 2] + modl[ 9] * proj[ 6] + modl[10] * proj[10] + modl[11] * proj[14];
   clip[11] = modl[ 8] * proj[ 3] + modl[ 9] * proj[ 7] + modl[10] * proj[11] + modl[11] * proj[15];

   clip[12] = modl[12] * proj[ 0] + modl[13] * proj[ 4] + modl[14] * proj[ 8] + modl[15] * proj[12];
   clip[13] = modl[12] * proj[ 1] + modl[13] * proj[ 5] + modl[14] * proj[ 9] + modl[15] * proj[13];
   clip[14] = modl[12] * proj[ 2] + modl[13] * proj[ 6] + modl[14] * proj[10] + modl[15] * proj[14];
   clip[15] = modl[12] * proj[ 3] + modl[13] * proj[ 7] + modl[14] * proj[11] + modl[15] * proj[15];

   /* Extract the numbers for the RIGHT plane */
   frustum[0][0] = clip[ 3] - clip[ 0];
   frustum[0][1] = clip[ 7] - clip[ 4];
   frustum[0][2] = clip[11] - clip[ 8];
   frustum[0][3] = clip[15] - clip[12];

   /* Normalize the result */
   t = sqrt( frustum[0][0] * frustum[0][0] + frustum[0][1] * frustum[0][1] + frustum[0][2] * frustum[0][2] );
   frustum[0][0] /= t;
   frustum[0][1] /= t;
   frustum[0][2] /= t;
   frustum[0][3] /= t;

   /* Extract the numbers for the LEFT plane */
   frustum[1][0] = clip[ 3] + clip[ 0];
   frustum[1][1] = clip[ 7] + clip[ 4];
   frustum[1][2] = clip[11] + clip[ 8];
   frustum[1][3] = clip[15] + clip[12];

   /* Normalize the result */
   t = sqrt( frustum[1][0] * frustum[1][0] + frustum[1][1] * frustum[1][1] + frustum[1][2] * frustum[1][2] );
   frustum[1][0] /= t;
   frustum[1][1] /= t;
   frustum[1][2] /= t;
   frustum[1][3] /= t;

   /* Extract the BOTTOM plane */
   frustum[2][0] = clip[ 3] + clip[ 1];
   frustum[2][1] = clip[ 7] + clip[ 5];
   frustum[2][2] = clip[11] + clip[ 9];
   frustum[2][3] = clip[15] + clip[13];

   /* Normalize the result */
   t = sqrt( frustum[2][0] * frustum[2][0] + frustum[2][1] * frustum[2][1] + frustum[2][2] * frustum[2][2] );
   frustum[2][0] /= t;
   frustum[2][1] /= t;
   frustum[2][2] /= t;
   frustum[2][3] /= t;

   /* Extract the TOP plane */
   frustum[3][0] = clip[ 3] - clip[ 1];
   frustum[3][1] = clip[ 7] - clip[ 5];
   frustum[3][2] = clip[11] - clip[ 9];
   frustum[3][3] = clip[15] - clip[13];

   /* Normalize the result */
   t = sqrt( frustum[3][0] * frustum[3][0] + frustum[3][1] * frustum[3][1] + frustum[3][2] * frustum[3][2] );
   frustum[3][0] /= t;
   frustum[3][1] /= t;
   frustum[3][2] /= t;
   frustum[3][3] /= t;

   /* Extract the FAR plane */
   frustum[4][0] = clip[ 3] - clip[ 2];
   frustum[4][1] = clip[ 7] - clip[ 6];
   frustum[4][2] = clip[11] - clip[10];
   frustum[4][3] = clip[15] - clip[14];

   /* Normalize the result */
   t = sqrt( frustum[4][0] * frustum[4][0] + frustum[4][1] * frustum[4][1] + frustum[4][2] * frustum[4][2] );
   frustum[4][0] /= t;
   frustum[4][1] /= t;
   frustum[4][2] /= t;
   frustum[4][3] /= t;

   /* Extract the NEAR plane */
   frustum[5][0] = clip[ 3] + clip[ 2];
   frustum[5][1] = clip[ 7] + clip[ 6];
   frustum[5][2] = clip[11] + clip[10];
   frustum[5][3] = clip[15] + clip[14];

   /* Normalize the result */
   t = sqrt( frustum[5][0] * frustum[5][0] + frustum[5][1] * frustum[5][1] + frustum[5][2] * frustum[5][2] );
   frustum[5][0] /= t;
   frustum[5][1] /= t;
   frustum[5][2] /= t;
   frustum[5][3] /= t;
}