// PFlameParticle.cpp: implementation of the PFlameParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PFlameParticle.h"
#include "PPokemon.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PFlameParticle::PFlameParticle(PGame * pGame, PDrawableObject * pSource):
	PParticle(pGame, pSource)
{
	width = length = 0.2f;

	fVelocity = 0.0f;
	fMaxSize = 0.0f;
	lifetime = 4.0f;

	bActive = true;
}

PFlameParticle::~PFlameParticle()
{

}

/* draws the flame particle and expands the bounding volume */

void PFlameParticle::Draw()
{
	glDisable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_TEXTURE_2D);
	
	float fSize = 0.25f;
	
	height = fMaxSize + rand() % 25 * 0.01f;
	pVolume.SetDimensions(width, length, height);
	float y;
	float w;

	for(float z=0.0f; z < height; z+=0.04f) {
		w = sqrt(height - z) * 0.20;

		for(y = 0.0f; y <= w; y+=0.04f) {
		
			fColor = 1.0f - (ABS(y) + ABS(z) * 0.5f) * 5.0f;
			glColor4f(1.0f, fColor + 0.5f, fColor, 1.0f);  
				
			glBindTexture(GL_TEXTURE_2D, textures[27]); 
			glBegin(GL_QUADS);
				glTexCoord2f(0,0);
				glVertex3f(0, y - .02f, z - .02f);
			
				glTexCoord2f(1,0);
				glVertex3f(0, y + .02f, z - .02f);
			
				glTexCoord2f(1,1);
				glVertex3f(0, y + .02f, z + .02f);
			
				glTexCoord2f(0,1);
				glVertex3f(0, y - .02f, z + .02f);	
			glEnd();

			glBegin(GL_QUADS);
				glTexCoord2f(0,0);
				glVertex3f(0, -y - .02f, z - .02f);
			
				glTexCoord2f(1,0);
				glVertex3f(0, -y + .02f, z - .02f);
			
				glTexCoord2f(1,1);
				glVertex3f(0, -y + .02f, z + .02f);
			
				glTexCoord2f(0,1);
				glVertex3f(0, -y - .02f, z + .02f);	
			glEnd();
		}
	}

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);

	float fTimeElapsed = pGame ->GetTimeElapsed();
	if(lifetime > 0) {
		if(fMaxSize < 1.0f) fMaxSize += fTimeElapsed;
		lifetime -= fTimeElapsed;
	} else {
		fMaxSize -= fTimeElapsed;
		if(fMaxSize < 0.0f) bActive = false;
	}
}

/* moves the flame particle */

void PFlameParticle::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(MC_MOVE_SURROUND);
}

/* handles the collision between this obstacle and a pokemon */

void PFlameParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	if(pObjectCollidedWith ->GetObjectType() == OBJ_TYPE_POKEMON) {
		PPokemon * pTarget = (PPokemon *) pObjectCollidedWith;
		if(pTarget!=pSource) 
		{
			float iDamage;
			PVector tVector,cVector;
			float x,y,z;

			cVector=GetCoordinates();
		
			cVector.subtract(&pTarget->GetCoordinates());
			cVector.makeUnit();
			cVector.invert();
			x=loc.x+cVector.getX();
			y=loc.y+cVector.getY();

			if(x>=(float)pGame->ground->GetXWidth()-1) x=(float)pGame->ground->GetXWidth()-1;
			if(x<=0) x=0;
			if(y>=(float)pGame->ground->GetYLength()-1) y=(float)(float)pGame->ground->GetYLength()-1;
			if(y<=0) y=0;

			z=pGame->ground->GetHeight(x,y);


			tVector=PVector(x,y,z);

			CPtrArray aCollidingObjects;

			pGame ->DetectCollisions(pTarget, pTarget->GetBoundVolume(), & aCollidingObjects);

			PDrawableObject * pCollidingObject;
			for(int i=0; i<aCollidingObjects.GetSize(); i++) {
				pCollidingObject=(PDrawableObject *) aCollidingObjects.GetAt(i);
				if(pCollidingObject->GetObjectType()==OBJ_TYPE_POKEMON && pCollidingObject!=pTarget) return;
			}

			if(pTarget->GetPokemonType()==PT_PIKACHU || pTarget->GetPokemonType()==PT_SQUIRTLE) {
				iDamage=.1;
				if(pTarget->GetPokemonType()==PT_SQUIRTLE) iDamage*=2;
				pTarget->TakeDamage(DT_NORMAL,iDamage);
			}
			pTarget->SetCoordinates(x,y,z);
		
		}
	}
}

bool PFlameParticle::IsActive()
{
	return bActive;
}
