// PFlameObstacle.cpp: implementation of the PFlameObstacle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PFlameObstacle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/* constructor - the base for the flame particle */

PFlameObstacle::PFlameObstacle(PGame * pGame)
{
	otObjType = OBJ_TYPE_WORLD;
	width = length = height = 0.1f;
	pVolume.SetDimensions(0, 0, 0);
	this ->pGame = pGame;
	pFlame = 0;
}

PFlameObstacle::~PFlameObstacle()
{

}

/* draws the base */

void PFlameObstacle::Draw()
{
	glTranslatef(0,0,-0.1f);
	glEnable(GL_LIGHTING);
	GLfloat black[] = { 0.0f, 0.0f, 0.0f, 1.0f};
	glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, black);
	glutSolidTorus(0.15f, 0.15f, 5, 10);

	if(!pFlame) { // if there's not currently a flame, randomly shoot a flame
		if(!(rand()%50)) {
			pFlame = new PFlameParticle(pGame, this);
			pFlame ->SetCoordinates(loc.x, loc.y, loc.z);
			pGame ->AddObject(pFlame);
		}
	} else if(pFlame && !pFlame ->IsActive()) {
		pGame ->RemoveObject(pFlame);
		pFlame = 0;
	}
	glDisable(GL_LIGHTING);
}
