// PFlameFountain.cpp: implementation of the PFlameFountain class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PFlameFountain.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/* contstructor for a flame fountain in the fire stage */

PFlameFountain::PFlameFountain(PGame * pGame, PDrawableObject * pSource):
	PParticle(pGame, pSource)
{
	groundBound=false;
	pVolume.SetDimensions(0.0f, 0.0f, 0.0f);
	fSize = (5 + rand()%5) * 0.01;
}

PFlameFountain::~PFlameFountain()
{

}

/* draws the flame particles */

void PFlameFountain::Draw()
{
	glDisable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, textures[49]); 

	glColor4f(1.0f, 0.4f, .4f, .5f);  

	glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex3f(0, -fSize, -fSize);
			
		glTexCoord2f(1,0);
		glVertex3f(0, fSize, - fSize);
			
		glTexCoord2f(1,1);
		glVertex3f(0, fSize, fSize);
			
		glTexCoord2f(0,1);
		glVertex3f(0, -fSize, fSize);	
	glEnd(); 

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND); 

	if(pDirection.z < 0 && loc.z + 0.25f<pGame->ground->GetHeight(loc.x,loc.y)) pGame ->RemoveObject(this);
	else pDirection.z -= 9.8 * pGame ->GetTimeElapsed();
}
