// PFireParticle.cpp: implementation of the PFireParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PFireParticle.h"
#include "PPokemon.h"
#include "PSmokeParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define FIRE_PARTS 25

void makeFire(float x, float y, float z);

/* constructor for charmander's flame attacks */

PFireParticle::PFireParticle(PGame *pGame, PDrawableObject *pSource, ATTACK_CODE acAttack):
	PParticle(pGame,pSource)
{
	this->acAttack=acAttack;
	this ->pGame = pGame;
	this->pSource=pSource;
	denomx=1000.0;
	denomy=700.0;
	denomz=1000.0;
	width = 0.75f;
	length = 0.5f;
	height = 0.75f;
	fDistance = .5f;
	loc.x=pSource->GetCoordinate(AXIS_X);
	loc.y=pSource->GetCoordinate(AXIS_Y);
	loc.z=pSource->GetCoordinate(AXIS_Z);
	if(pGame->GetGameOption(GO_SOUND)==1) {
		PSound *pSound=pGame->GetSoundObject();
		pSound->PlaySound(SOUND_FIRE, false,this->Distance(pGame->GetFocusObject()));
	}
	if(acAttack==AC_NORMAL_ATTACK) {
		lifetime=1.0;
		fVelocity = 10.0f;
	} else if(acAttack==AC_CLOSE_ATTACK) {
		lifetime=.2;
		fVelocity=5.0;
	}
	pVolume.SetDimensions(width, length, height);
}

PFireParticle::~PFireParticle()
{

}

/* makes a fire particle for charmander */

void PFireParticle::makeFire(float x,float y, float z) {
	glBegin(GL_TRIANGLE_STRIP);
		glVertex3f(x-.05,y-.05,z-.05);
		glVertex3f(x-.05,y+.05,z-.05);
		glVertex3f(x+.05,y+.05,z+.05);
		glVertex3f(x+.05,y-.05,z+.05);
	glEnd();
}

/* draws the fire particles */

void PFireParticle::Draw()
{

	GLfloat mat_diffuse[] = { 1.0f, 0.2, 0.05, 1.0 };
	GLfloat mat_specular[]={1.0,.5,.5,.5};
	GLfloat low_shininess[]={128.0};
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, low_shininess);

	//if the projectile hits the ground, smoke rises
	if(loc.z+0.1f<pGame->ground->GetHeight(loc.x,loc.y)) {
		active=false;
		PSmokeParticle *pSmoke=new PSmokeParticle(pGame,pGame->ground);
		pSmoke ->SetCoordinates(loc.x, loc.y, .05+ pGame->ground->GetHeight(loc.x, loc.y) );
		pSmoke ->Rotate(AXIS_Z, rz);
		pGame ->AddObject(pSmoke);
		//return;*/
	}
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);;
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glTranslatef(0.3,0.0,.3);
	if(acAttack==AC_NORMAL_ATTACK) {
		mat_diffuse[3]=lifetime;
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);
		glColor4f(1.0,.5,0.0,lifetime);
		glutSolidSphere(.1,5,5);
	}
		
	float r,r1,r2,red,gr,bl;

	glColor4f(1.0,0.0,0.0,lifetime);
	srand(time(NULL));
	for(int i=0;i<FIRE_PARTS;i++) {
		r=-(float)(rand()%100)/denomx;
		r1=(float)(rand()%100)/denomy;
		r2=(float)(rand()%100)/denomz;

		red=((float)rand())/RAND_MAX+.5;
		if(red>1.0) red=1.0;
		gr=((float)rand())/RAND_MAX-.5;
		bl=((float)rand())/RAND_MAX-.8;
		if(gr<0.0) gr=0.0;
		if(bl<0.0) bl=0.0;

		mat_diffuse[0]=red;
		mat_diffuse[1]=gr;
		mat_diffuse[2]=bl;
		if(acAttack==AC_NORMAL_ATTACK) mat_diffuse[3]=lifetime;
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);

		if(rand()%2==0) r1=-r1;
		if(rand()%2==0) r2=-r2;
		makeFire(r,r1,r2);
	}
	glDisable(GL_BLEND);
}

/* moves the fire particle */

void PFireParticle::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(mcMove);
	fDistance += fVelocity * pGame ->GetTimeElapsed();
	if(acAttack==AC_CLOSE_ATTACK) {
		denomx-=300.0*pGame->GetTimeElapsed();
		denomy-=300.0*pGame->GetTimeElapsed();
		denomz-=100.0*pGame->GetTimeElapsed();
		if(denomx<=0) denomx=100.0;
		if(denomy<=0) denomy=100.0;
		if(denomz<=0) denomz=100.0;
		width+=.1;
		height+=.1;
		pVolume.SetDimensions(width, length, height);
		this->SetCoordinates(pSource->GetCoordinate(AXIS_X),pSource->GetCoordinate(AXIS_Y),pSource->GetCoordinate(AXIS_Z));
	}
	lifetime-=pGame->GetTimeElapsed();
	if((fDistance > 10.0 && acAttack==AC_NORMAL_ATTACK) || (lifetime<0.0 && acAttack==AC_CLOSE_ATTACK) || !active) {
		pGame ->RemoveObject(this);
	}
}

/* handles the collision between the fire particle and a pokemon */

void PFireParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	if(pObjectCollidedWith ->GetObjectType() == OBJ_TYPE_POKEMON) {
		PPokemon * pTarget = (PPokemon *) pObjectCollidedWith;
		if(pTarget!=pSource && !pTarget ->IsBlocking()) {
			int iDamage;
			PVector tVector,cVector;
			float x,y,z;
			x=loc.x+pDirection.getX();
			y=loc.y+pDirection.getY();
			if(x>=(float)pGame->ground->GetXWidth()-1) x=(float)pGame->ground->GetXWidth()-1;
			if(x<=0) x=0;
			if(y>=(float)pGame->ground->GetYLength()-1) y=(float)(float)pGame->ground->GetYLength()-1;
			if(y<=0) y=0;
			/*if(pGame->ground->GetHeight(x,y)<0) {
				x=loc.x;
				y=loc.y;
			}*/
			z=pGame->ground->GetHeight(x,y);

			tVector=PVector(x,y,z);

			CPtrArray aCollidingObjects;

			pGame ->DetectCollisions(pTarget, pTarget->GetBoundVolume(), & aCollidingObjects);

			PDrawableObject * pCollidingObject;
			for(int i=0; i<aCollidingObjects.GetSize(); i++) {
				pCollidingObject=(PDrawableObject *) aCollidingObjects.GetAt(i);
				if(pCollidingObject->GetObjectType()==OBJ_TYPE_POKEMON && pCollidingObject!=pTarget) return;
			}

			if(pSource ->GetObjectType() == OBJ_TYPE_POKEMON) {
				 int iAttack = ((PPokemon *) pSource) ->GetStat(PS_ATTACK) * 0.25f;
				 iDamage = iAttack + rand() % iAttack;
			} else {
				iDamage = 10;
			}
			if(acAttack==AC_NORMAL_ATTACK) pTarget ->TakeDamage(DT_FIRE, iDamage);
			else if(acAttack==AC_CLOSE_ATTACK) pTarget ->TakeDamage(DT_FIRE, iDamage * 2);

			pTarget->SetCoordinates(tVector.getX(),tVector.getY(),tVector.getZ());
			pGame ->RemoveObject(this);
		}
	}
}
