// PExperienceWindow.cpp: implementation of the PExperienceWindow class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "gltext.h"
#include "PExperienceWindow.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PExperienceWindow::PExperienceWindow(PGame * pGame)
{
	pPokemon = 0;
	this ->pGame = pGame;
}

PExperienceWindow::~PExperienceWindow()
{

}

void PExperienceWindow::Draw()
{	
	if(!pPokemon) return;
	glPushMatrix();
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(-1.0, 1.0, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glPushMatrix();
	glTranslatef(0.0f, 0.2f, 0.0f);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D,textures[21]);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f,0.0f); glVertex2f(-fExpSize * 2.0 ,-fExpSize * 0.75);
		glTexCoord2f(1.0f,0.0f); glVertex2f(fExpSize * 2.0, -fExpSize * 0.75);
		glTexCoord2f(1.0f,1.0f); glVertex2f(fExpSize * 2.0, fExpSize);
		glTexCoord2f(0.0f,1.0f); glVertex2f(-fExpSize * 2.0,fExpSize);
	glEnd();
	glDisable(GL_TEXTURE_2D);
	glPopMatrix();

	// experience earned window
	if(fExpSize < 0.25f) fExpSize *= 2.0f;
	else {
		glColor3f(1.0, 1.0, 1.0);
		glDrawText(0.2f * iWindowWidth, 0.25f * iWindowHeight, pPokemon ->GetName(), FONT_POKEMON_NAME);
		
		glDrawText(0.2f * iWindowWidth, 0.3f * iWindowHeight, "Level", FONT_EXPERIENCE);
		sprintf(buffer, "%d", pPokemon ->GetStat(PS_LEVEL));
		glDrawText(0.6f * iWindowWidth, 0.3f * iWindowHeight, buffer, FONT_EXPERIENCE);
	
	
		glDrawText(0.2f * iWindowWidth, 0.35f * iWindowHeight, "Exp Earned", FONT_EXPERIENCE);
		sprintf(buffer, "%d", iExperience);
		glDrawText(0.6f * iWindowWidth, 0.35f * iWindowHeight, buffer, FONT_EXPERIENCE);
	
		glDrawText(0.2f * iWindowWidth, 0.4f * iWindowHeight, "Experience", FONT_EXPERIENCE);
		sprintf(buffer, "%d", pPokemon ->GetStat(PS_EXPERIENCE));
		glDrawText(0.6f * iWindowWidth, 0.4f * iWindowHeight, buffer, FONT_EXPERIENCE);

		glDrawText(0.2f * iWindowWidth, 0.45f * iWindowHeight, "Next Level", FONT_EXPERIENCE);
		if(pPokemon ->GetStat(PS_NEXTLEVEL) > 0) {
			sprintf(buffer, "%d", pPokemon ->GetStat(PS_NEXTLEVEL));
			glDrawText(0.6f * iWindowWidth, 0.45f * iWindowHeight, buffer, FONT_EXPERIENCE);
		} else {
			glDrawText(0.6f * iWindowWidth, 0.45f * iWindowHeight, "***", FONT_EXPERIENCE);
		}
	}
	
	// level up window
	float fAspectRatio = (float) iWindowHeight / iWindowWidth;
	if(bLevelUp) {
		glTranslatef(0.0f, -0.5, 0.0f);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,textures[21]);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f); glVertex2f(-fLevelSize * 2.0 ,-fLevelSize * 0.75);
			glTexCoord2f(1.0f,0.0f); glVertex2f(fLevelSize * 2.0, -fLevelSize * 0.75);
			glTexCoord2f(1.0f,1.0f); glVertex2f(fLevelSize * 2.0, fLevelSize);
			glTexCoord2f(0.0f,1.0f); glVertex2f(-fLevelSize * 2.0,fLevelSize);
		glEnd();
		glDisable(GL_TEXTURE_2D);
	
		if(fLevelSize < 0.25f) fLevelSize *= 2.0f;
		else {
			glBegin(GL_TRIANGLES);
				glVertex2f(0.25f, 0.16f); glVertex2f(0.25f, 0.19f); glVertex2f(0.28f, 0.175f);
				glVertex2f(0.25f, 0.055f); glVertex2f(0.25f, 0.085f); glVertex2f(0.28f, 0.070f);
				glVertex2f(0.25f, -0.05f); glVertex2f(0.25f, -0.02f); glVertex2f(0.28f, -0.035f);
				glVertex2f(0.25f, -0.155f); glVertex2f(0.25f, -0.125f); glVertex2f(0.28f, -0.140f);
			glEnd();
			glColor3f(1.0, 1.0, 1.0);
			glDrawText(0.2f * iWindowWidth, 0.6f * iWindowHeight, "Level Up!", FONT_POKEMON_NAME);
			
			glDrawText(0.2f * iWindowWidth, 0.65f * iWindowHeight, "Level", FONT_EXPERIENCE);
			sprintf(buffer, "%d", iCurLevel);
			glDrawText(0.55f * iWindowWidth, 0.65 * iWindowHeight, buffer, FONT_EXPERIENCE);
			sprintf(buffer, "%d", pPokemon ->GetStat(PS_LEVEL));
			glDrawText(0.685f * iWindowWidth, 0.65 * iWindowHeight, buffer, FONT_EXPERIENCE); 


			glDrawText(0.2f * iWindowWidth, 0.7f * iWindowHeight, "HP", FONT_EXPERIENCE);
			sprintf(buffer, "%d", iCurHp);
			glDrawText(0.55f * iWindowWidth, 0.7 * iWindowHeight, buffer, FONT_EXPERIENCE);
			sprintf(buffer, "%d", pPokemon ->GetStat(PS_HP));
			glDrawText(0.685f * iWindowWidth, 0.7 * iWindowHeight, buffer, FONT_EXPERIENCE); 

			glDrawText(0.2f * iWindowWidth, 0.75f * iWindowHeight, "Attack", FONT_EXPERIENCE);
			sprintf(buffer, "%d", iCurAttack);
			glDrawText(0.55f * iWindowWidth, 0.75 * iWindowHeight, buffer, FONT_EXPERIENCE);
			sprintf(buffer, "%d", pPokemon ->GetStat(PS_ATTACK));
			glDrawText(0.685f * iWindowWidth, 0.75 * iWindowHeight, buffer, FONT_EXPERIENCE); 


			glDrawText(0.2f * iWindowWidth, 0.8f * iWindowHeight, "Speed", FONT_EXPERIENCE);
			sprintf(buffer, "%d", iCurSpeed);
			glDrawText(0.55f * iWindowWidth, 0.8 * iWindowHeight, buffer, FONT_EXPERIENCE);
			sprintf(buffer, "%d", pPokemon ->GetStat(PS_SPEED));
			glDrawText(0.685f * iWindowWidth, 0.8 * iWindowHeight, buffer, FONT_EXPERIENCE); 
		}
	}

	glPopMatrix();
	if(bCountDown) {
		if(iExperience > 0) CountDown();
	}
}



void PExperienceWindow::Initialize(PPokemon *pPokemon, int iExperience)
{
	this ->pPokemon = pPokemon; 
	this ->iExperience = iExperience;
	iDecrement = iExperience / 10;
	fExpSize = 0.1f;
	bCountDown = false;
	bLevelUp = false;
}

// counts down experience, and marks level ups
void PExperienceWindow::CountDown()
{
	int curExp = pPokemon ->GetStat(PS_EXPERIENCE);
	int toNext;
	int toSubtract = (iExperience < iDecrement) ? iExperience: iDecrement;
	if(pPokemon ->GetStat(PS_NEXTLEVEL) > 0) {
		toNext = pPokemon ->GetStat(PS_NEXTLEVEL) - curExp;
	} else {
		toNext = toSubtract + 1;
	}
	

	if(toSubtract >= toNext) {
		toSubtract = toNext;
		iCurLevel = pPokemon ->GetStat(PS_LEVEL);
		iCurHp = pPokemon ->GetStat(PS_HP);
		iCurAttack = pPokemon ->GetStat(PS_ATTACK);
		iCurSpeed = pPokemon ->GetStat(PS_SPEED);
		pPokemon ->GainLevel();
		fLevelSize = 0.1f;
		bLevelUp = true;
		bCountDown = false;
	} 
	
	iExperience -= toSubtract;
	pPokemon ->SetStat(PS_EXPERIENCE, curExp + toSubtract);
}

void PExperienceWindow::Keyboard(unsigned char key, int x, int y)
{
	if(key == 13) {
		if(iExperience == 0 && bCountDown == true) {
			// if there is no more experience to be added, save character
			if(pPokemon ->IsAlive()) {
				pGame ->SetCharacter(PS_POKEMON, pPokemon ->GetStat(PS_POKEMON));
				pGame ->SetCharacter(PS_LEVEL, pPokemon ->GetStat(PS_LEVEL));
				pGame ->SetCharacter(PS_EXPERIENCE, pPokemon ->GetStat(PS_EXPERIENCE));
				pGame ->SetCharacter(PS_NEXTLEVEL, pPokemon ->GetStat(PS_NEXTLEVEL));
				pGame ->SetCharacter(PS_HP, pPokemon ->GetStat(PS_HP));
				pGame ->SetCharacter(PS_ATTACK, pPokemon ->GetStat(PS_ATTACK));
				pGame ->SetCharacter(PS_SPEED, pPokemon ->GetStat(PS_SPEED));
				pGame ->Save();
				pGame ->StartGame();
			}
			else pGame ->SetGameState(GS_START_MENU);
		} else if(bCountDown == false) {
			bLevelUp = false;
			bCountDown = true;
		}
	}
}
