// PDrawableObject.h: interface for the PDrawableObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PDRAWABLEOBJECT_H__616F7AB7_F5FC_4F3D_BBCA_4D6691E0A21E__INCLUDED_)
#define AFX_PDRAWABLEOBJECT_H__616F7AB7_F5FC_4F3D_BBCA_4D6691E0A21E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PObject.h"
#include "PBoundVolume.h"

class PDrawableObject : public PObject  
{
public:
	PVector GetCoordinates();
	virtual void Draw()=0;
	bool IsGroundBound();
	virtual void Rotate(AXIS axis, float fAngle);
	PBoundVolume * GetBoundVolume();
	virtual void HandleCollision(PDrawableObject * pObjectCollidedWith);
	float Distance(PDrawableObject * pObject);
	void SetCoordinate(AXIS axis, float value);
	float GetCoordinate(AXIS axis);
	float GetDimension(DIM dimension);
	void SetCoordinates(float x, float y, float z);
	void TranslateForDrawing();

	PDrawableObject();
	virtual ~PDrawableObject();
	bool shouldDraw;

protected:
	void RotateForDrawing();
	float width, length, height;
	PVector loc;
	float rx, ry, rz;
	PBoundVolume pVolume;
	bool groundBound;
	bool sideBound;
};

#endif // !defined(AFX_PDRAWABLEOBJECT_H__616F7AB7_F5FC_4F3D_BBCA_4D6691E0A21E__INCLUDED_)
