// PDrawableObject.cpp: implementation of the PDrawableObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PDrawableObject.h"
#include "GL/glut.h"
#include "math.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PDrawableObject::PDrawableObject()
{
	loc.x = loc.y = loc.z = 0.0f;
	height = length = width = 0.0f;
	rx = ry = rz = 0.0f;
	shouldDraw = true;
}

PDrawableObject::~PDrawableObject()
{

}

void PDrawableObject::SetCoordinates(float x, float y, float z)
{
	loc.x = x;
	loc.y = y;
	loc.z = z;
	pVolume.SetCoordinates(x,y,z);
}

float PDrawableObject::GetCoordinate(AXIS axis)
{
	switch(axis) {
	case AXIS_X: return loc.x;
	case AXIS_Y: return loc.y;
	case AXIS_Z: return loc.z;
	default: return 0.0;
	}
}

float PDrawableObject::GetDimension(DIM dimension) {
	switch(dimension) {
	case D_WIDTH: return width;
	case D_LENGTH: return length;
	case D_HEIGHT: return height;
	default: return 0.0;
	}
}

void PDrawableObject::SetCoordinate(AXIS axis, float value)
{
	switch(axis) {
	case AXIS_X: loc.x = value; break;
	case AXIS_Y: loc.y = value; break;
	case AXIS_Z: loc.z = value; break;
	}
	pVolume.SetCoordinates(loc.x,loc.y,loc.z);
}

float PDrawableObject::Distance(PDrawableObject *pObject)
{
	float dx, dy, dz;
	dx = loc.x - pObject ->loc.x;
	dy = loc.y - pObject ->loc.y;
	dz = loc.z - pObject ->loc.z;

	return (float) sqrt(dx * dx + dy * dy + dz * dz);
}

void PDrawableObject::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	// do nothing
}

PBoundVolume * PDrawableObject::GetBoundVolume()
{
	return & pVolume;
}

void PDrawableObject::Rotate(AXIS axis, float fAngle)
{
	float * pr;
	switch(axis) {
	case AXIS_X: pr = & rx; break;	
	case AXIS_Y: pr = & ry; break;
	case AXIS_Z: pr = & rz; break;
	}
	
	*pr += fAngle;
	while(*pr > 360.0f) {
		*pr -= 360.0f;
	}
	while(*pr < 0) {
		*pr += 360.0f;
	}

	pVolume.SetRotation(rx, ry, rz);
}

bool PDrawableObject::IsGroundBound()
{
	return groundBound;
}

void PDrawableObject::TranslateForDrawing()
{
	if(groundBound) glTranslatef(loc.x,loc.y,loc.z + height * 0.5);
	else glTranslatef(loc.x,loc.y,loc.z);
}

void PDrawableObject::Draw()
{
}

void PDrawableObject::RotateForDrawing()
{
	if(rz) glRotatef(-rz, 0.0, 0.0, 1.0);
	if(rx) glRotatef(rx, 1.0, 0.0, 0.0);
	if(ry) glRotatef(ry, 0.0, 1.0, 0.0);
}

PVector PDrawableObject::GetCoordinates()
{
	return loc;
}
