// PCharacterMenu.cpp: implementation of the PCharacterMenu class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PCharacterMenu.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/* constructor - sets initial values for the menu */

PCharacterMenu::PCharacterMenu(PGame * pGame)
{
	charselx=-.6f;
	charsely=0.0f;
	charseloffsetx=.02f;
	charseloffsety=.02f;
	this ->pGame = pGame;
}

PCharacterMenu::~PCharacterMenu()
{

}

/* draws the character menu */

void PCharacterMenu::Draw()
{
	GLfloat pickx=.5f,picky=.1f,optx=.2f,opty=.1f, charsx=.2f,charsy=.3f;

	SelectCharBox(charsx+charseloffsetx,charsy+charseloffsety);

	//draw string "pick a character"
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glEnable(GL_TEXTURE_2D);
	glTranslatef(-.55f,.8f,0.0f);
	glBindTexture(GL_TEXTURE_2D, textures[7]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-pickx,-picky,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(pickx,-picky,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(pickx,picky,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-pickx,picky,0.0f);
	glEnd();
	//draw pikachu
	glLoadIdentity();
	glTranslatef(-.6f,0.0f,0.0f);
	glBindTexture(GL_TEXTURE_2D, textures[3]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-charsx,-charsy,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(charsx,-charsy,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(charsx,charsy,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-charsx,charsy,0.0f);
	glEnd();

	//draw charmander
	glLoadIdentity();
	glTranslatef(0.0f,0.0f,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[4]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-charsx,-charsy,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(charsx,-charsy,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(charsx,charsy,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-charsx,charsy,0.0f);
	glEnd();

	//draw squirtle
	glLoadIdentity();
	glTranslatef(.6f,0.0f,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[5]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-charsx,-charsy,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(charsx,-charsy,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(charsx,charsy,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-charsx,charsy,0.0f);
	glEnd();

	//draw back button
	glLoadIdentity();
	glTranslatef(.7f,-.8f,0.0f);
	glBindTexture(GL_TEXTURE_2D,textures[8]);
	glBegin(GL_QUADS);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0f,0.0f,1.0f);
		glTexCoord2f(0.0f,0.0f); glVertex3f(-optx,-opty,0.0f);
		glTexCoord2f(1.0f,0.0f); glVertex3f(optx,-opty,0.0f);
		glTexCoord2f(1.0f,1.0f); glVertex3f(optx,opty,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex3f(-optx,opty,0.0f);
	glEnd();

	glDisable(GL_TEXTURE_2D);

}

/* draws the selection box */

void PCharacterMenu::SelectCharBox(GLfloat x, GLfloat y)
{
	glDisable(GL_TEXTURE_2D);
	glLoadIdentity();
	glTranslatef(charselx,charsely,0.0f);
	glBegin(GL_QUADS);
		glColor3f(.0f,.0f,.8f);
		glNormal3f(0.0f,0.0f,1.0f);
		glVertex3f(-x,-y,0.0f);
		glVertex3f(x,-y,0.0f);
		glVertex3f(x,y,0.0f);
		glVertex3f(-x,y,0.0f);
	glEnd();
	glEnable(GL_TEXTURE_2D);
}

/* determines what to do when pressing left/right, up/down, enter keys */

void PCharacterMenu::Keyboard(unsigned char key, int x, int y)
{
	switch(key) {
	// return
	case 13:
		if(charsely==0.0f) {
			if(charselx==-.6f) pGame->SetCharacter(PS_POKEMON,0);
			else if(charselx==0.0f) pGame->SetCharacter(PS_POKEMON,1);
			else if(charselx==.6f) pGame->SetCharacter(PS_POKEMON,2);
			//if(menu.sound) PlaySound("diamond.wav",NULL,SND_FILENAME|SND_ASYNC);

			pGame ->SetCharacter(PS_LEVEL, 1);
			pGame ->SetCharacter(PS_EXPERIENCE, 0);
			pGame ->SetCharacter(PS_NEXTLEVEL, 100);
			pGame ->SetCharacter(PS_HP, 30 + rand() % 5);
			pGame ->SetCharacter(PS_ATTACK, 10 + rand() % 2);
			pGame ->SetCharacter(PS_SPEED, 10 + rand() % 2);
					
			pGame ->StartGame();
		} else if(charsely==-.8f) {
			charsely=0.0f;
			charselx=prevcharselx;
			charseloffsetx=.02f;
			charseloffsety=.02f;
			pGame ->SetGameState(GS_START_MENU);
		}
		break;
	// left (4)
	case 52:
		if(charselx==.6f) charselx=0.0f;
		else if(charselx==-.6f) charselx=.6f;
		else if(charselx==0.0f) charselx=-.6f;
		break;
	// right (6)
	case 54:
		if(charselx==.6f) charselx=-.6f;
		else if(charselx==0.0f) charselx=.6f;
		else if(charselx==-.6f) charselx=0.0f;
		break;
	
	// up (8)	
	case 56: 
		if(charsely==0.0f) {			/* determine if choosing character */
				prevcharselx=charselx;	/* or going back to main menu */
				charseloffsetx=0.02;
				charseloffsety=-.18f;
				charselx=.7f;
				charsely=-.8f;
		} else if(charsely==-.8f) {
				charseloffsetx=.02f;
				charseloffsety=.02f;
				charselx=prevcharselx;
				charsely=0.0f;
		}
		break;
	//down (2)
	case 50:
		if(charsely==0.0f) {			/* determine if choosing a character or */
			prevcharselx=charselx;		/* going back to main menu */
			charseloffsetx=0.02f;
			charseloffsety=-.18f;
			charselx=.7f;
			charsely=-.8f;
		} else if(charsely==-.8f) {
			charseloffsetx=.02f;
			charseloffsety=.02f;
			charselx=prevcharselx;
			charsely=0.0f;
		} 
		break;
	// esc
	case 27:
		charselx=-.6f;
		charsely=0.0f;
		charseloffsetx=.02f;
		charseloffsety=.02f;
		pGame ->SetGameState(GS_START_MENU);
		break;
	}
}
