// PCamera.h: interface for the PCamera class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PCAMERA_H__F26874B1_89D0_4138_9302_5AC81E406108__INCLUDED_)
#define AFX_PCAMERA_H__F26874B1_89D0_4138_9302_5AC81E406108__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PObject.h"
#include "PGame.h"
#include "PMovableObject.h"
#include "PPokemon.h"
#include "PPoint.h"
#include "PFont.h"
#include "PExperienceWindow.h"	// Added by ClassView

class PCamera : public PObject  
{
public:
	void SetExperience();
	PExperienceWindow pExpWind;
	void GetNextTarget();
	void KeyboardUp(unsigned char key, int x, int y);
	void Keyboard(unsigned char key, int x, int y);
	int GetHeight();
	int GetWidth();
	PMovableObject * GetFocusObject();
	void ResizeWindow(int w, int h);
	void Draw();
	PCamera(PGame * pGame, PPokemon * pFocusObject, int w, int h);
	virtual ~PCamera();

protected:
	int w, h;
	PGame * pGame;
	PPokemon * pFocusObject;

private:
	void DrawEnergyBars();
	void DrawObjectArray(CPtrArray * pObjects);
	void DrawRadar();
};

#endif // !defined(AFX_PCAMERA_H__F26874B1_89D0_4138_9302_5AC81E406108__INCLUDED_)
