// PBubbleParticle.cpp: implementation of the PBubbleParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PBubbleParticle.h"
#include "PPokemon.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define BUBBLE_PARTS 5

void makeBubble(float x, float y, float z);

/* constructor - initializes the sound and sets the properties of the bubble particle */

PBubbleParticle::PBubbleParticle(PGame *pGame, PDrawableObject *pSource, ATTACK_CODE acAttack):
	PParticle(pGame,pSource)
{
	srand(time(NULL));

	lifetime=0.5f;

	fDistance = .5;
	fVelocity = 10.0f;
	this ->pGame = pGame;
	this->pSource=pSource;
	this->acAttack=acAttack;
	width = 0.75f;
	length = 0.1f;
	height = 0.75f;
	denomx=800.0;
	denomy=800.0;
	denomz=800.0;
	radius=.3;
	loc.x=pSource->GetCoordinate(AXIS_X);
	loc.y=pSource->GetCoordinate(AXIS_Y);
	loc.z=pSource->GetCoordinate(AXIS_Z);
	if(pGame->GetGameOption(GO_SOUND)==1) {
		PSound *pSound=pGame->GetSoundObject();
		if(acAttack==AC_NORMAL_ATTACK) pSound->PlaySound(SOUND_WAVE, false,this->Distance(pGame->GetFocusObject()));
		else if(acAttack==AC_CLOSE_ATTACK) pSound->PlaySound(SOUND_BUBBLE,false,this->Distance(pGame->GetFocusObject()));
	}
	if(acAttack==AC_NORMAL_ATTACK) {
		lifetime=1.0;
		fVelocity = 10.0f;
	} else if(acAttack==AC_CLOSE_ATTACK) {
		width=height=.5;
		length=1.0;
		lifetime=.25;
		fDistance=0.0;
		fVelocity=5.0;
	}
	pVolume.SetDimensions(width, length, height);
}

PBubbleParticle::~PBubbleParticle()
{

}

/* draws a bubble */

void PBubbleParticle::makeBubble(float x, float y, float z) {
	glTranslatef(x,y,z);
	glPushMatrix();
	glutSolidSphere(.1,4,4);
	glPopMatrix();
}

/* draw function */

void PBubbleParticle::Draw()
{

	GLfloat mat_diffuse[] = { 0.1f, 0.1f, 1.0f, .5 };

	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_diffuse);

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_BLEND);

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

/*	if(acAttack==AC_NORMAL_ATTACK) {
		glColor4f(.2,.2,1.0,.25);
		glTranslatef(0.3,0.0,.3);
	
		float r,r1,r2;
		for(int i=0;i<BUBBLE_PARTS;i++) {
			r=(float)(rand()%100)/denomx;
			r1=(float)(rand()%100)/denomy;
			r2=(float)(rand()%100)/denomz;
	
			if(rand()%2==0) r=-r;
			if(rand()%2==0) r1=-r1;
			if(rand()%2==0) r2=-r2;
			makeBubble(r,r1,r2);
		}
	} else if(acAttack==AC_CLOSE_ATTACK) {*/
		glutSolidSphere(radius,10,10);
	//}
	glDisable(GL_BLEND);
}

/* move function for squirtle's close attack-if squirtle is running, moves the bubble with him */

void PBubbleParticle::Move(MOVE_CODE mcMove)
{
	float fTimeElapsed = pGame ->GetTimeElapsed();
	if(acAttack==AC_NORMAL_ATTACK) {
		PProjectile::Move(mcMove);
		fDistance += fVelocity * pGame ->GetTimeElapsed();
	} else if(acAttack==AC_CLOSE_ATTACK) {
		PProjectile::Move(MC_MOVE_SURROUND);
		radius+=2.0f * fTimeElapsed;
		width+=4.0f * fTimeElapsed;
		height+=4.0f * fTimeElapsed;
		length+=4.0f * fTimeElapsed;
		pVolume.SetCoordinates(pSource->GetCoordinate(AXIS_X),pSource->GetCoordinate(AXIS_Y),pSource->GetCoordinate(AXIS_Z));
		pVolume.SetDimensions(width, length, height);
		this->SetCoordinates(pSource->GetCoordinate(AXIS_X),pSource->GetCoordinate(AXIS_Y),pSource->GetCoordinate(AXIS_Z));
	}
	lifetime-=pGame ->GetTimeElapsed();
	if((fDistance > 10.0 && acAttack==AC_NORMAL_ATTACK) || (lifetime<0.0 && acAttack==AC_CLOSE_ATTACK) || !active) {
		Draw();
		pGame ->RemoveObject(this);
	}
}

/* handles a collision between a projectile and another pokemon - gives the damage, removes the projectile, etc.*/

void PBubbleParticle::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	if(pObjectCollidedWith ->GetObjectType() == OBJ_TYPE_POKEMON) {
		PPokemon * pTarget = (PPokemon *) pObjectCollidedWith;
		if(pTarget!=pSource && !pTarget ->IsBlocking()) {
			int iDamage;
			PVector tVector,cVector;
			float x,y,z;

			if(acAttack==AC_NORMAL_ATTACK) {
				x=loc.x+pDirection.getX();
				y=loc.y+pDirection.getY();
			} else if(acAttack==AC_CLOSE_ATTACK) {
				cVector=this->GetCoordinates();
				cVector.subtract(&pTarget->GetCoordinates());
				cVector.multiply(1.5);
				cVector.invert();
				x=loc.x+cVector.getX();
				y=loc.y+cVector.getY();
			}

			if(x>=(float)pGame->ground->GetXWidth()-1) x=(float)pGame->ground->GetXWidth()-1;
			if(x<=0) x=0;
			if(y>=(float)pGame->ground->GetYLength()-1) y=(float)(float)pGame->ground->GetYLength()-1;
			if(y<=0) y=0;

			z=pGame->ground->GetHeight(x,y);

			tVector=PVector(x,y,z);

			CPtrArray aCollidingObjects;

			pGame ->DetectCollisions(pTarget, pTarget->GetBoundVolume(), & aCollidingObjects);

			PDrawableObject * pCollidingObject;
			for(int i=0; i<aCollidingObjects.GetSize(); i++) {
				pCollidingObject=(PDrawableObject *) aCollidingObjects.GetAt(i);
				if(pCollidingObject->GetObjectType()==OBJ_TYPE_POKEMON && pCollidingObject!=pTarget) return;
			}

			if(pSource ->GetObjectType() == OBJ_TYPE_POKEMON) {
				 int iAttack = ((PPokemon *) pSource) ->GetStat(PS_ATTACK) * 0.25f;
				 iDamage = iAttack + rand() % iAttack;
			} else {
				iDamage = 10;
			}
			if(acAttack==AC_NORMAL_ATTACK) pTarget ->TakeDamage(DT_WATER, iDamage);
			else if(acAttack==AC_CLOSE_ATTACK) pTarget ->TakeDamage(DT_WATER, iDamage * 2);

			pTarget->SetCoordinates(tVector.getX(),tVector.getY(),tVector.getZ());
			pGame ->RemoveObject(this);
		}
	}
}