// PBoundVolume.h: interface for the PBoundVolume class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PBOUNDVOLUME_H__3DA4FE21_34D5_49D1_A4EA_1AAED51EF753__INCLUDED_)
#define AFX_PBOUNDVOLUME_H__3DA4FE21_34D5_49D1_A4EA_1AAED51EF753__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "pvector.h"
#include "PObject.h"

//#define PI 3.1415926535897932
//#define NUM_SIDES 6

class PBoundVolume : public PObject 
{
public:
	float RaySphereIntersect(PVector * o, PVector * dir, float fRadius);
	float RaySphereIntersect(PVector *origin, PVector * direction);
	PBoundVolume();
	void SetRotation(float rx, float ry, float rz);
	void SetDimensions(float xLen, float yLen, float zLen);
	void SetCoordinates(float x, float y, float z);
	float Distance(PBoundVolume * pVolume);
	float GetMaxLength();
	bool DetectIntersection(PBoundVolume * B);
	PBoundVolume(PBoundVolume & source);
	PBoundVolume(float x, float y, float z, float xLen, float yLen, float zLen, float rx, float ry, float rz);
	virtual ~PBoundVolume();
	static PVector GetNormal(PVector pt1, PVector pt2, PVector pt3);
	//static PVector *Corners(float x, float y, float z, float width, float length, float height, float divx, float divy, float divz,PVector *corner);
	//static bool IntersectedPolygons(PVector *poly1, PVector *poly2, int numVertex1, int numVertex2,MOVE_CODE mcMove);
	//PVector *GetPos() { return pos; }
	//void Collided();
	float x, y, z; // center
	float hu, hv, hw; // half lengths - bind xLen to u, yLen to v, zLen to w

protected:
	//static float PlaneDistance(PVector normal, PVector pt);
	//static bool PlanesFacing(PVector *poly1, PVector *poly2, PVector &normal1, PVector &normal2);
	//static bool PolygonsIntersect(PVector *poly1, PVector *poly2,PVector normal1, PVector normal2, int numVertex1, int numVertex2, MOVE_CODE mcMove);
	//PVector IntersectionPoint(PVector normal, PVector *line, float dist);
	
	//float length, width, height;
	float rx, ry, rz; // rotation about the x,y,z axes in degrees
	float fMaxLen;
};

#endif // !defined(AFX_PBOUNDVOLUME_H__3DA4FE21_34D5_49D1_A4EA_1AAED51EF753__INCLUDED_)
