// PBoundVolume.cpp: implementation of the PBoundVolume class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PBoundVolume.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


PBoundVolume::PBoundVolume()
{
	SetCoordinates(0.0f, 0.0f, 0.0f);
	SetDimensions(0.0f, 0.0f, 0.0f);
	SetRotation(0.0f, 0.0f, 0.0f);
}


PBoundVolume::PBoundVolume(float x, float y, float z, float xLen, float yLen, float zLen,
						   float rx, float ry, float rz) 
{	
	SetCoordinates(x,y,z);
	SetDimensions(xLen, yLen, zLen);
	SetRotation(rx,ry,rz);
}

PBoundVolume::PBoundVolume(PBoundVolume & source)
{
	SetCoordinates(source.x, source.y, source.z);
	SetDimensions(source.hu * 2.0f, source.hv * 2.0f, source.hw * 2.0f);
	SetRotation(source.rx, source.ry, source.rz);
}

PBoundVolume::~PBoundVolume()
{

}

// use separating-axis algorithm to detect intersection between two OBBs
bool PBoundVolume::DetectIntersection(PBoundVolume *B)
{
	if((!hu && !hv && !hw) || (!B ->hu && !B ->hv && !B ->hw)) return false;
	float drx, dry, drz; // difference in rotation
	
	drx = (float) (RADIAN(B ->rx - rx));
	dry = (float) (RADIAN(B ->ry - ry));
	drz = (float) (RADIAN(B ->rz - rz));

	float R[3][3];

	// construct relative rotation matrix
	R[0][0] = (float) (cos(dry) * cos(drz) - sin(drx) * sin(dry) * sin(drz));
	R[0][1] = (float) (cos(dry) * sin(drz) + sin(drx) * sin(dry) * sin(drz));
	R[0][2] = (float) (- cos(drx) * sin(dry));

	R[1][0] = (float) (- cos(drx) * sin(drz));
	R[1][1] = (float) (cos(drz) * cos(drx));
	R[1][2] = (float) (sin(drx));

	R[2][0] = (float) (sin(dry) * cos(drz) + sin(drx) * cos(dry) * sin(drz));
	R[2][1] = (float) (sin(dry) * sin(drz) - sin(drx) * cos(dry) * cos(drz));
	R[2][2] = (float) (cos(drx) * cos(dry));

	// absolute value of R - used many times, so cached for faster performance
	float AR[3][3];
	for(int i=0; i<3; i++) {
		for(int j= 0; j<3; j++) {
			AR[i][j] = ABS(R[i][j]);
		}
	}

	float tx, ty, tz;
	tx = B ->x - x;
	ty = B ->y - y;
	tz = B ->z - z;
			
	if(ABS(tx) > hu + B ->hu * AR[0][0] + B ->hv * AR[0][1] + B ->hw * AR[0][2]) {
		// testing edge au
	} else if(ABS(ty) > hv + B -> hv * AR[1][0] + B ->hv * AR[1][1] + B ->hw * AR[1][2]) {
		// testing edge av
	} else if(ABS(tz) > hw + B ->hw * AR[2][0] + B ->hw * AR[2][1] + B ->hw * AR[2][2]) {
		// testing edge aw
	} else if(fabs(tx * R[0][0] + ty * R[1][0] + tz * R[2][0]) >
		hu * AR[0][0] + hv * AR[1][0] + hw * AR[2][0] + B ->hu) {
		// testing edge bu
	} else if(fabs(tx * R[0][1] + ty * R[1][1] + tz * R[2][1]) >
		hu * AR[0][1] + hv * AR[1][1] + hw * AR[2][1] + B ->hv) {
		// testing edge bv
	} else if(fabs(tx * R[0][2] + ty * R[1][2] + tz * R[2][2]) >
		hu * AR[0][2] + hv * AR[1][2] + hw * AR[2][2]) {
		// testing edge bw
	} else if(fabs(tz * R[1][0] - ty * R[2][0]) >
		hv * AR[2][0] + hw * AR[1][0] + B ->hv * AR[0][2] + B ->hw * AR[0][1]) {
		// testing edge au x bu
	} else if(fabs(tz * R[1][1] - ty * R[2][1]) > 
		hv * AR[2][1] + hw * AR[1][1] + B ->hu * AR[0][2] + B ->hw * AR[0][0]) {
		// testing edge au x bv
	} else if(fabs(tz * R[1][2] - ty * R[2][2]) > 
		hv * AR[2][2] + hw * AR[1][2] + B ->hu * AR[0][1] + B ->hv * AR[0][0]) {
		// testing edge au x bw
	} else if(fabs(tx * R[2][0] - tz * R[0][0]) >
		hu * AR[2][0] + hw * AR[0][0] + B ->hv * AR[1][2] + B ->hw * AR[1][1]) {
		// testing edge av x bu
	} else if(fabs(tx * R[2][1] - tz * R[0][1]) > 
		hu * AR[2][1] + hw * AR[0][1] + B ->hu * AR[1][2] + B ->hw * AR[1][0]) {
		// testing edge av x bv
	} else if(fabs(tx * R[2][2] - tz * R[0][2]) >
		hu * AR[2][2] + hw * AR[0][2] +	B ->hu * AR[1][1] + B ->hv * AR[1][0]) {
		// testing edge av x bw
	} else if(fabs(-tx * R[1][0] + ty * R[0][0]) >
		hu * AR[1][0] + hv * AR[0][0] + B ->hv * AR[2][2] + B ->hw * AR[2][1]) {
		// testing edge aw x bu
	} else if(fabs(-tx * R[1][1] + ty * R[0][1]) >
		hu * AR[1][1] + hw * AR[0][1] + B ->hu * AR[2][2] + B ->hw * AR[2][0]) {
		// testing edge aw x bv
	} else if(fabs(-tx * R[1][2] + ty * R[0][2]) >
		hu * AR[1][2] + hw * AR[0][2] + B ->hv * AR[2][2] + B ->hw * AR[2][1]) {
		// testing edge aw x bw
	} else {
		return true;
	}

	return false;
}

float PBoundVolume::Distance(PBoundVolume *pVolume)
{
	float dx, dy, dz;
	dx = x - pVolume ->x;
	dy = y - pVolume ->y;
	dz = z - pVolume ->z;

	return (float) sqrt(dx * dx + dy * dy + dz * dz);
}

float PBoundVolume::GetMaxLength()
{
	return fMaxLen;
}


void PBoundVolume::SetCoordinates(float x, float y, float z)
{
	this ->x = x;
	this ->y = y;
	this ->z = z;
}

void PBoundVolume::SetDimensions(float xLen, float yLen, float zLen)
{
	hu = xLen * 0.5f;
	fMaxLen = hu;
	hv = yLen * 0.5f;
	if(hv > fMaxLen) fMaxLen = hv;
	hw = zLen * 0.5f;
	if(hw > fMaxLen) fMaxLen = hw;
}

void PBoundVolume::SetRotation(float rx, float ry, float rz)
{
	this ->rx = rx;
	this ->ry = ry;
	this ->rz = rz;
}


// returns -1.0 if there is no intersection
float PBoundVolume::RaySphereIntersect(PVector * o, PVector * dir)
{
	return RaySphereIntersect(o, dir, 0.0f);
}

// uses maximum halfwidth as radius of sphere, returns t where t * dir marks location of intersection
// radius parameter is radius of ray for predicting collisions of volumes
float PBoundVolume::RaySphereIntersect(PVector *o, PVector *dir, float fRadius)
{
	if(fMaxLen <= 0.0f) return -1.0f;
	fRadius += fMaxLen;
	PVector l(x,y,z);
	l.subtract(o);
	float d = l.dotProduct(dir);
	float l2 = l.dotProduct(&l);
	float r2 = fRadius * fRadius;
	if(d < 0.0f && l2 > r2) return -1.0f;
	float m2 = l2 - d * d;
	if(m2 > r2) return -1.0f;
	float q = (float) sqrt(r2 - m2);
	float t;
	if(l2 > r2) t = d - q;
	else t = d + q;
	return t;
}
