// P3DSModel.h: interface for the P3DSModel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_P3DSMODEL_H__21F6AB94_FF7F_4D2A_9794_C34C315B4000__INCLUDED_)
#define AFX_P3DSMODEL_H__21F6AB94_FF7F_4D2A_9794_C34C315B4000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PObject.h"
#include "GL/glut.h"
#include <vector>
using namespace std;

// This is our 3D point class.  This will be used to store the vertices
// of our model.
struct tVector3 {
	float x, y, z;
};

// This is our 2D point class.  This will be used to store the UV coordinates.
struct tVector2 {
	float x, y;
};

// This is our face structure.  This is is used for indexing into the vertex 
// and texture coordinate arrays.  From this information we know which vertices
// from our vertex array go to which face, along with the correct texture coordinates.
struct tFace
{
	int vertIndex[3];			// indicies for the verts that make up this triangle
	int coordIndex[3];			// indicies for the tex coords to texture this face
};

// This holds the information for a material.  It may be a texture map of a color.
// Some of these are not used, but I left them because you will want to eventually
// read in the UV tile ratio and the UV tile offset for some models.
struct tMaterialInfo
{
	char  strName[255];			// The texture name
	char  strFile[255];			// The texture file name (If this is set it's a texture map)
	BYTE  color[3];				// The color of the object (R, G, B)
	int   texureId;				// the texture ID
	float uTile;				// u tiling of texture  (Currently not used)
	float vTile;				// v tiling of texture	(Currently not used)
	float uOffset;			    // u offset of texture	(Currently not used)
	float vOffset;				// v offset of texture	(Currently not used)
} ;

// This holds all the information for our model/scene. 
// You should eventually turn into a robust class that 
// has loading/drawing/querying functions like:
// LoadModel(...); DrawObject(...); DrawModel(...); DestroyModel(...);
struct t3DObject 
{
	int  numOfVerts;			// The number of verts in the model
	int  numOfFaces;			// The number of faces in the model
	int  numTexVertex;			// The number of texture coordinates
	int  materialID;			// The texture ID to use, which is the index into our texture array
	bool bHasTexture;			// This is TRUE if there is a texture map for this object
	char strName[255];			// The name of the object
	tVector3  *pVerts;			// The object's vertices
	tVector3  *pNormals;		// The object's normals
	tVector2  *pTexVerts;		// The texture's UV coordinates
	tFace *pFaces;				// The faces information of the object
};

// This holds our model information.  This should also turn into a robust class.
// We use STL's (Standard Template Library) vector class to ease our link list burdens. :)

class P3DSModel : public PObject  
{
public:
	void SetBaseTexture(int iBaseTextureID);
	void Draw();
	P3DSModel(GLuint * pTextures);
	virtual ~P3DSModel();

	int numOfObjects;					// The number of objects in the model
	int numOfMaterials;					// The number of materials for the model
	vector<tMaterialInfo> pMaterials;	// The list of material information (Textures and colors)
	vector<t3DObject> pObject;			// The object list for our model
protected:
	int iBaseTextureID;
	GLuint * pTextures;
};



#endif // !defined(AFX_P3DSMODEL_H__21F6AB94_FF7F_4D2A_9794_C34C315B4000__INCLUDED_)
