// P3DSModel.cpp: implementation of the P3DSModel class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "P3DSModel.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

P3DSModel::P3DSModel(GLuint * pTextures)
{	
	iBaseTextureID = 0;
	numOfMaterials = 0;
	numOfObjects = 0;
	this ->pTextures = pTextures;
}

P3DSModel::~P3DSModel()
{

}

void P3DSModel::Draw()
{
	/*glEnable(GL_LIGHTING);
	
	glEnable(GL_LIGHT0);
	*/
	glEnable(GL_DEPTH_TEST);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	//glOrtho(-1.5, 1.5, 1.5, 1.5, 0.0, 3.0);
	glMatrixMode(GL_MODELVIEW); 	
	gluLookAt(0.0, 0.0, 5, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	glLoadIdentity();
	//glRotatef(90.0, 1.0, 0.0, 0.0);
	
	// Since we know how many objects our model has, go through each of them.
	for(int i = 0; i < numOfObjects; i++)
	{
		// Make sure we have valid objects just in case. (size() is in the vector class)
		if(pObject.size() <= 0) break;

		// Get the current object that we are displaying
		t3DObject *pCurObject = &pObject[i];
			
		// Check to see if this object has a texture map, if so bind the texture to it.
		if(pCurObject->bHasTexture) {

			// Turn on texture mapping and turn off color
			glEnable(GL_TEXTURE_2D);

			// Reset the color to normal again
			glColor3ub(255, 255, 255);

			// Bind the texture map to the object by it's materialID
			
			glBindTexture(GL_TEXTURE_2D, pTextures[pCurObject->materialID + iBaseTextureID]);
		} else {

			// Turn off texture mapping and turn on color
			glDisable(GL_TEXTURE_2D);

			// Reset the color to normal again
			glColor3ub(255, 255, 255);
		}

		// This determines if we are in wireframe or normal mode
		glBegin(GL_TRIANGLES);					// Begin drawing with our selected mode (triangles or lines)

			// Go through all of the faces (polygons) of the object and draw them
			for(int j = 0; j < pCurObject->numOfFaces; j++)
			{
				// Go through each corner of the triangle and draw it.
				for(int whichVertex = 0; whichVertex < 3; whichVertex++)
				{
					// Get the index for each point of the face
					int index = pCurObject->pFaces[j].vertIndex[whichVertex];
			
					// Give OpenGL the normal for this vertex.
					glNormal3f(pCurObject->pNormals[ index ].x, pCurObject->pNormals[ index ].y, pCurObject->pNormals[ index ].z);
				
					// If the object has a texture associated with it, give it a texture coordinate.
					if(pCurObject->bHasTexture) {

						// Make sure there was a UVW map applied to the object or else it won't have tex coords.
						if(pCurObject->pTexVerts) {
							glTexCoord2f(pCurObject->pTexVerts[ index ].x, pCurObject->pTexVerts[ index ].y);
						}
					} else {

						// Make sure there is a valid material/color assigned to this object.
						// You should always at least assign a material color to an object, 
						// but just in case we want to check the size of the material list.
						// if the size is at least one, and the material ID != -1,
						// then we have a valid material.
						if(pMaterials.size() && pCurObject->materialID >= 0) 
						{
							// Get and set the color that the object is, since it must not have a texture
							BYTE *pColor = pMaterials[pCurObject->materialID].color;

							// Assign the current color to this model
							glColor3ub(pColor[0], pColor[1], pColor[2]);
						}
					}

					// Pass in the current vertex of the object (Corner of current face)
					glVertex3f(pCurObject->pVerts[ index ].x, pCurObject->pVerts[ index ].y, pCurObject->pVerts[ index ].z);
				}
			}

		glEnd();								// End the drawing
	}
}

void P3DSModel::SetBaseTexture(int iBaseTextureID)
{
	this ->iBaseTextureID = iBaseTextureID;
}
