//==================================================================//
//==================================================================//
//= Math.cpp =======================================================//
//==================================================================//
//= Original coder: Trent Polack (ShiningKnight) ===================//
//==================================================================//
//==================================================================//

#include "stdafx.h"
#include "MD2.h"




//------------------------------------------------------------------//
//- VERTEX(float, float, float) ------------------------------------//
//------------------------------------------------------------------//
//- Description: The constructor that intializes the parts of the  -//
//-				 vector to your specifications.					   -//
//------------------------------------------------------------------//
VERTEX::
	VERTEX(float x, float y, float z)
	{
	vertex[0]=x;
	vertex[1]=y;
	vertex[2]=z;
	}

//------------------------------------------------------------------//
//- void VERTEX::SendToOGL(void) -----------------------------------//
//------------------------------------------------------------------//
//- Description: This function sends the class's vertex array to   -//
//-				 OpenGL.										   -//
//------------------------------------------------------------------//
void VERTEX::
	SendToOGL(void)
	{	glVertex3fv(vertex);	}

//------------------------------------------------------------------//
//- inline VERTEX VERTEX::operator+ (VERTEX) -----------------------//
//------------------------------------------------------------------//
//- Description: Overloading the + operator, allowing you to add   -//
//-				 one vertex to another, with some nice looking     -//
//-				 code.											   -//
//------------------------------------------------------------------//
inline VERTEX VERTEX::
	operator+ (const VERTEX &v)
	{
	VERTEX result(0.0f, 0.0f, 0.0f);

	result.vertex[0]= vertex[0] + v.vertex[0];
	result.vertex[1]= vertex[1] + v.vertex[1];
	result.vertex[2]= vertex[2] + v.vertex[2];

	return result;
	}

//------------------------------------------------------------------//
//- inline VERTEX VERTEX::operator- (VERTEX) -----------------------//
//------------------------------------------------------------------//
//- Description: Overloading the - operator, allowing you to	   -//
//-				 subtract one vertex to another, with some nice	   -//
//-				 looking code.									   -//
//------------------------------------------------------------------//
inline VERTEX VERTEX::
	operator- (const VERTEX &v)
	{
	VERTEX result(0.0f, 0.0f, 0.0f);

	result.vertex[0]= vertex[0] - v.vertex[0];
	result.vertex[1]= vertex[1] - v.vertex[1];
	result.vertex[2]= vertex[2] - v.vertex[2];

	return result;
	}


//------------------------------------------------------------------//
//- inline VECTOR VECTOR::operator* (float) ------------------------//
//------------------------------------------------------------------//
//- Description: Overloading the * operator, this allows you to    -//
//-				 multiply a every component of a vertex by a scalar-//
//-				 (single value).								   -//
//------------------------------------------------------------------//
inline VERTEX VERTEX::
	operator* (const float scalar)
	{
	VERTEX result(0.0f, 0.0f, 0.0f);

	result.vertex[0]= vertex[0] * scalar;
	result.vertex[1]= vertex[1] * scalar;
	result.vertex[2]= vertex[2] * scalar;

	return result;
	}

//------------------------------------------------------------------//
//- inline VERTEX VERTEX::operator* (VERTEX) -----------------------//
//------------------------------------------------------------------//
//- Description: Overloading the * operator.  But this time it is  -//
//-				 for vertex by vertex multiplication.			   -//
//------------------------------------------------------------------//
inline VERTEX VERTEX::
	operator* (const VERTEX &v)
	{
	VERTEX result(0.0f, 0.0f, 0.0f);

	result.vertex[0]= vertex[0] * v.vertex[0];
	result.vertex[1]= vertex[1] * v.vertex[1];
	result.vertex[2]= vertex[2] * v.vertex[2];

	return result;
	}

//------------------------------------------------------------------//
//- inline VERTEX VERTEX::operator/ (VERTEX) -----------------------//
//------------------------------------------------------------------//
//- Description: Overloading the / operator, allowing you to divide-//
//-				 one vertex to another.							   -//
//------------------------------------------------------------------//
inline VERTEX VERTEX::
	operator/ (const VERTEX &v)
	{
	VERTEX result(0.0f, 0.0f, 0.0f);

	result.vertex[0]= vertex[0] / v.vertex[0];
	result.vertex[1]= vertex[1] / v.vertex[1];
	result.vertex[2]= vertex[2] / v.vertex[2];

	return result;
	}

