#ifndef BUILDING_GLUTAR_LIB
# pragma comment (lib, "winmm.lib")     // link with Windows MultiMedia lib
# pragma comment (lib, "opengl32.lib")  // link with Microsoft OpenGL lib
# pragma comment (lib, "glu32.lib")     // link with Microsoft OpenGL Utility lib
# ifdef _DEBUG
#  pragma comment (lib, "..\\..\\glutar\\Debug\\glutar.lib")  // link with Win32 GLUT lib
# else
#  pragma comment (lib, "..\\..\\glutar\\Release\\glutar.lib")  // link with Win32 GLUT lib
# endif
#endif
#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>

/*
#define GLUTAR_RGB			0
#define GLUTAR_RGBA			GLUTAR_RGB
#define GLUTAR_INDEX		1
#define GLUTAR_SINGLE		0
#define GLUTAR_DOUBLE		2
#define GLUTAR_ACCUM		4
#define GLUTAR_ALPHA		8
#define GLUTAR_DEPTH		16
#define GLUTAR_STENCIL		32
*/

#define GLUT_RGB			0
#define GLUT_RGBA			GLUT_RGB
#define GLUT_INDEX			1
#define GLUT_SINGLE			0
#define GLUT_DOUBLE			2
#define GLUT_ACCUM			4
#define GLUT_ALPHA			8
#define GLUT_DEPTH			16
#define GLUT_STENCIL		32

#define GLUTAR_FULLSCREEN	(1<<10)

# ifndef GLUT_NO_WARNING_DISABLE
#  pragma warning (disable:4244)  /* Disable bogus VC++ 4.2 conversion warnings. */
#  pragma warning (disable:4305)  /* VC++ 5.0 version of above warning. */
# endif

/* Mouse buttons. */
#define GLUT_LEFT_BUTTON		0
#define GLUT_MIDDLE_BUTTON		1
#define GLUT_RIGHT_BUTTON		2

/* Mouse button  state. */
#define GLUT_DOWN			0
#define GLUT_UP				1


#define GLUTARAPI
#define ARAPIENTRY
#define GLUTARCALLBACK

GLUTARAPI void ARAPIENTRY glutarDisplayFunc(void (GLUTARCALLBACK *func)(void));
GLUTARAPI void ARAPIENTRY glutarReshapeFunc(void (GLUTARCALLBACK *func)(int width, int height));
GLUTARAPI void ARAPIENTRY glutarKeyboardFunc(void (GLUTARCALLBACK *func)(unsigned char key, int x, int y));
GLUTARAPI void ARAPIENTRY glutarMouseFunc(void (GLUTARCALLBACK *func)(int button, int state, int x, int y));
GLUTARAPI void ARAPIENTRY glutarMotionFunc(void (GLUTARCALLBACK *func)(int x, int y));
GLUTARAPI void ARAPIENTRY glutarPassiveMotionFunc(void (GLUTARCALLBACK *func)(int x, int y));
GLUTARAPI void ARAPIENTRY glutarIdleFunc(void (GLUTARCALLBACK *func)(void));
GLUTARAPI void ARAPIENTRY glutarFocusFunc(void (GLUTARCALLBACK *func)(bool losingFocus));


bool glutarCreateWindow(char* title);
void glutarInit(int *argc, char* argv[]);
void glutarInitDisplayMode(unsigned int mode);
void glutarInitWindowSize(int width, int height);
void glutarInitWindowPosition(int x, int y);
bool glutarChangeWindowSettings(char* title, int x, int y, int width, int height, int bits, bool fullscreen,int freq=60);
void glutarSwapBuffers(void);
void glutarPostRedisplay(void);
int  glutarMainLoop(void);
void glutarQuit(void);

// Holds the configuration information for a glutar window
struct glutarConfig_type
{
	// Currently in full screen mode?
	bool fullscreen;
	// Display mode options
	unsigned int displaymode;

	// Initial height/width
	int win_width;
	int win_height;
	int init_win_pos_x;
	int init_win_pos_y;
	int bitdepth;			// video bitdepth
	int displayfreq;

	bool done;				// Time to quit?

	// context info
	HDC			hDC;		// Private GDI Device Context
	HGLRC		hRC;		// Permanent Rendering Context
	HWND		hWnd;		// Holds Our Window Handle
	HINSTANCE	hInstance;	// Holds The Instance Of The Application

	/*void (GLUTARCALLBACK *initFunc)(void);*/
	void (GLUTARCALLBACK *displayFunc)(void);
	void (GLUTARCALLBACK *reshapeFunc)(int width, int height);
	void (GLUTARCALLBACK *keyboardFunc)(unsigned char key, int x, int y);
	void (GLUTARCALLBACK *mouseFunc)(int button, int state, int x, int y);
	void (GLUTARCALLBACK *motionFunc)(int x, int y);
	void (GLUTARCALLBACK *passiveMotionFunc)(int x, int y);
	void (GLUTARCALLBACK *idleFunc)(void);
	void (GLUTARCALLBACK *focusFunc)(bool losingFocus);
};

extern glutarConfig_type glutarConfig;
