#include "glutar.h"
#include <windows.h>

#include <stdio.h>

struct glutarConfig_type glutarConfig;
bool	active=TRUE;		// Window Active Flag Set To TRUE By Default

void emptyDisplayFunc(void)
{ return; }
void emptyReshapeFunc(int width, int height)
{ return; }
void emptyKeyboardFunc(unsigned char key, int x, int y)
{ return; }
void emptyMouseFunc(int button, int state, int x, int y)
{ return; }
void emptyMotionFunc(int x, int y)
{ return; }

void glutarInit(int *argc, char* argv[])
{
	glutarConfig.fullscreen = false;
	glutarConfig.displaymode = 0;
	glutarConfig.win_width = CW_USEDEFAULT;
	glutarConfig.win_height = CW_USEDEFAULT;
	glutarConfig.init_win_pos_x = CW_USEDEFAULT;
	glutarConfig.init_win_pos_y = CW_USEDEFAULT;
	glutarConfig.bitdepth = 32;
	glutarConfig.displayfreq = 60;
	glutarConfig.hDC = NULL;	
	glutarConfig.hRC = NULL;	
	glutarConfig.hWnd = NULL;	
	glutarConfig.hInstance;
	/*glutarConfig.initFunc = emptyInitFunc;*/
	glutarConfig.displayFunc = emptyDisplayFunc;
	glutarConfig.reshapeFunc = NULL;
	glutarConfig.keyboardFunc = NULL;
	glutarConfig.mouseFunc = NULL;
	glutarConfig.motionFunc = NULL;
	glutarConfig.motionFunc = NULL;
	glutarConfig.idleFunc = NULL;
	glutarConfig.focusFunc = NULL;
	glutarConfig.done = false;
	return;
}
void glutarInitDisplayMode(unsigned int mode)
{
	glutarConfig.displaymode = mode;
	glutarConfig.fullscreen  = ((mode&GLUTAR_FULLSCREEN)!=0);
}
void glutarInitWindowSize(int width, int height)
{
	glutarConfig.win_width = width;
	glutarConfig.win_height = height;
}
void glutarInitWindowPosition(int x, int y)
{
	glutarConfig.init_win_pos_x = x;
	glutarConfig.init_win_pos_y = y;
}

GLUTARAPI void ARAPIENTRY glutarDisplayFunc(void (GLUTARCALLBACK *func)(void))
{	glutarConfig.displayFunc = func;	}
GLUTARAPI void ARAPIENTRY glutarReshapeFunc(void (GLUTARCALLBACK *func)(int width, int height))
{	glutarConfig.reshapeFunc = func;	}
GLUTARAPI void ARAPIENTRY glutarKeyboardFunc(void (GLUTARCALLBACK *func)(unsigned char key, int x, int y))
{	glutarConfig.keyboardFunc = func;	}
GLUTARAPI void ARAPIENTRY glutarMouseFunc(void (GLUTARCALLBACK *func)(int button, int state, int x, int y))
{	glutarConfig.mouseFunc = func;	}
GLUTARAPI void ARAPIENTRY glutarMotionFunc(void (GLUTARCALLBACK *func)(int x, int y))
{	glutarConfig.motionFunc = func;	}
GLUTARAPI void ARAPIENTRY glutarPassiveMotionFunc(void (GLUTARCALLBACK *func)(int x, int y))
{	glutarConfig.passiveMotionFunc = func;	}
GLUTARAPI void ARAPIENTRY glutarIdleFunc(void (GLUTARCALLBACK *func)(void))
{	glutarConfig.idleFunc = func;	}
GLUTARAPI void ARAPIENTRY glutarFocusFunc(void (GLUTARCALLBACK *func)(bool losingFocus))
{	glutarConfig.focusFunc = func;	}


/*	This Code Creates Our OpenGL Window.  Parameters Are:					*
 *	title			- Title To Appear At The Top Of The Window				*
 *	width			- Width Of The GL Window Or Fullscreen Mode				*
 *	height			- Height Of The GL Window Or Fullscreen Mode			*
 *	bits			- Number Of Bits To Use For Color (8/16/24/32)			*
 *	fullscreenflag	- Use Fullscreen Mode (TRUE) Or Windowed Mode (FALSE)	*/

LRESULT CALLBACK WndProc(	HWND	hWnd,			// Handle For This Window
							UINT	uMsg,			// Message For This Window
							WPARAM	wParam,			// Additional Message Information
							LPARAM	lParam)			// Additional Message Information
{
	switch (uMsg)									// Check For Windows Messages
	{
		case WM_ACTIVATE:							// Watch For Window Activate Message
		{
			if (!HIWORD(wParam))					// Check Minimization State
			{
				active=TRUE;						// Program Is Active
			}
			else
			{
				active=FALSE;						// Program Is No Longer Active
			}

			return 0;								// Return To The Message Loop
		}

		case WM_SYSCOMMAND:							// Intercept System Commands
		{
			switch (wParam)							// Check System Calls
			{
				case SC_SCREENSAVE:					// Screensaver Trying To Start?
				case SC_MONITORPOWER:				// Monitor Trying To Enter Powersave?
				return 0;							// Prevent From Happening
			}
			break;									// Exit
		}

		case WM_CLOSE:								// Did We Receive A Close Message?
		{
			PostQuitMessage(0);						// Send A Quit Message
			return 0;								// Jump Back
		}

		case WM_CHAR:
		{
			unsigned char key = wParam;
			if (glutarConfig.keyboardFunc)
				glutarConfig.keyboardFunc(key,0,0);
			return 0;
		}
		case WM_LBUTTONUP:
		{
			int xPos = LOWORD(lParam); 
			int yPos = HIWORD(lParam);
			if (glutarConfig.mouseFunc)
				glutarConfig.mouseFunc(GLUT_LEFT_BUTTON,GLUT_UP,xPos,yPos);
			return 0;
		}
		case WM_LBUTTONDOWN:
		{
			int xPos = LOWORD(lParam); 
			int yPos = HIWORD(lParam);
			if (glutarConfig.mouseFunc)
				glutarConfig.mouseFunc(GLUT_LEFT_BUTTON,GLUT_DOWN,xPos,yPos);
			return 0;
		}

		case WM_RBUTTONUP:
		{
			int xPos = LOWORD(lParam); 
			int yPos = HIWORD(lParam);
			if (glutarConfig.mouseFunc)
				glutarConfig.mouseFunc(GLUT_RIGHT_BUTTON,GLUT_UP,xPos,yPos);
			return 0;
		}
		case WM_RBUTTONDOWN:
		{
			int xPos = LOWORD(lParam); 
			int yPos = HIWORD(lParam);
			if (glutarConfig.mouseFunc)
				glutarConfig.mouseFunc(GLUT_RIGHT_BUTTON,GLUT_DOWN,xPos,yPos);
			return 0;
		}

		case WM_MBUTTONUP:
		{
			int xPos = LOWORD(lParam); 
			int yPos = HIWORD(lParam);
			if (glutarConfig.mouseFunc)
				glutarConfig.mouseFunc(GLUT_MIDDLE_BUTTON,GLUT_UP,xPos,yPos);
			return 0;
		}
		case WM_MBUTTONDOWN:
		{
			int xPos = LOWORD(lParam); 
			int yPos = HIWORD(lParam);
			if (glutarConfig.mouseFunc)
				glutarConfig.mouseFunc(GLUT_MIDDLE_BUTTON,GLUT_DOWN,xPos,yPos);
			return 0;
		}

		case WM_MOUSEMOVE:
		{
			int xPos = LOWORD(lParam); 
			int yPos = HIWORD(lParam);
			if (glutarConfig.motionFunc)
				glutarConfig.motionFunc(xPos,yPos);
			return 0;
		}
		case WM_PAINT:
		{
			glutarConfig.displayFunc();
			break;									// Need to allow default message handle
		}											// to validate the window

		case WM_KILLFOCUS:
			{
				if (glutarConfig.focusFunc)
					glutarConfig.focusFunc(false);
				break;
			}
		case WM_SETFOCUS:
			{
				if (glutarConfig.focusFunc)
					glutarConfig.focusFunc(true);
				break;
			}

		case WM_SIZE:								// Resize The OpenGL Window
		{
			glutarConfig.win_width = LOWORD(lParam);
			glutarConfig.win_height = HIWORD(lParam);
			if (glutarConfig.reshapeFunc)
				glutarConfig.reshapeFunc(glutarConfig.win_width,glutarConfig.win_height);
			return 0;								// Jump Back
		}
	}

	// Pass All Unhandled Messages To DefWindowProc
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

GLvoid KillGlutarWindow(GLvoid)								// Properly Kill The Window
{
	if (glutarConfig.fullscreen)										// Are We In Fullscreen Mode?
	{
		ChangeDisplaySettings(NULL,0);					// If So Switch Back To The Desktop
		ShowCursor(TRUE);								// Show Mouse Pointer
	}

	if (glutarConfig.hRC)											// Do We Have A Rendering Context?
	{
		if (!wglMakeCurrent(NULL,NULL))					// Are We Able To Release The DC And RC Contexts?
		{
			MessageBox(NULL,"Release Of DC And RC Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(glutarConfig.hRC))						// Are We Able To Delete The RC?
		{
			MessageBox(NULL,"Release Rendering Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}
		glutarConfig.hRC=NULL;										// Set RC To NULL
	}

	if (glutarConfig.hDC && !ReleaseDC(glutarConfig.hWnd,glutarConfig.hDC))					// Are We Able To Release The DC
	{
		MessageBox(NULL,"Release Device Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		glutarConfig.hDC=NULL;										// Set DC To NULL
	}

	if (glutarConfig.hWnd && !DestroyWindow(glutarConfig.hWnd))					// Are We Able To Destroy The Window?
	{
		MessageBox(NULL,"Could Not Release hWnd.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		glutarConfig.hWnd=NULL;										// Set hWnd To NULL
	}

	if (!UnregisterClass("GlutarGLWin",glutarConfig.hInstance))			// Are We Able To Unregister Class
	{
		MessageBox(NULL,"Could Not Unregister Class.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		glutarConfig.hInstance=NULL;									// Set hInstance To NULL
	}
}

bool glutarCreateWindow(char* title)
{
	GLuint		PixelFormat;			// Holds The Results After Searching For A Match
	WNDCLASS	wc;						// Windows Class Structure
	DWORD		dwExStyle;				// Window Extended Style
	DWORD		dwStyle;				// Window Style
	RECT		WindowRect;				// Grabs Rectangle Upper Left / Lower Right Values

	int ix = glutarConfig.init_win_pos_x;
	int iy = glutarConfig.init_win_pos_y;
	int width = glutarConfig.win_width;
	int height = glutarConfig.win_height;
	int bits = glutarConfig.bitdepth;
	int freq = glutarConfig.displayfreq;
	bool fullscreen;

	WindowRect.left=(long)0;			// Set Left Value To 0
	WindowRect.right=(long)width;		// Set Right Value To Requested Width
	WindowRect.top=(long)0;				// Set Top Value To 0
	WindowRect.bottom=(long)height;		// Set Bottom Value To Requested Height

	fullscreen=glutarConfig.fullscreen;			// Set The Global Fullscreen Flag

	glutarConfig.hInstance	= GetModuleHandle(NULL);				// Grab An Instance For Our Window
	wc.style				= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;	// Redraw On Size, And Own DC For Window.
	wc.lpfnWndProc			= (WNDPROC) WndProc;					// WndProc Handles Messages
	wc.cbClsExtra			= 0;									// No Extra Window Data
	wc.cbWndExtra			= 0;									// No Extra Window Data
	wc.hInstance			= glutarConfig.hInstance;				// Set The Instance
	wc.hIcon				= LoadIcon(NULL, IDI_WINLOGO);			// Load The Default Icon
	wc.hCursor				= LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
	wc.hbrBackground		= NULL;									// No Background Required For GL
	wc.lpszMenuName			= NULL;									// We Don't Want A Menu
	wc.lpszClassName		= "GlutarGLWin";						// Set The Class Name

	if (!RegisterClass(&wc))									// Attempt To Register The Window Class
	{
		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;											// Return false
	}
	
	if (fullscreen)												// Attempt Fullscreen Mode?
	{
		DEVMODE dmScreenSettings;								// Device Mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= width;				// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= height;				// Selected Screen Height
		//dmScreenSettings.dmDisplayFrequency = 85;
		dmScreenSettings.dmDisplayFrequency = freq;
		dmScreenSettings.dmBitsPerPel	= bits;					// Selected Bits Per Pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT|DM_DISPLAYFREQUENCY;

		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			// If The Mode Fails, Offer Two Options.  Quit Or Use Windowed Mode.
			if (MessageBox(NULL,"The Requested Fullscreen Mode Is Not Supported By\nYour Video Card. Use Windowed Mode Instead?","NeHe GL",MB_YESNO|MB_ICONEXCLAMATION)==IDYES)
			{
				fullscreen=glutarConfig.fullscreen=false;		// Windowed Mode Selected.  Fullscreen = false
			}
			else
			{
				// Pop Up A Message Box Letting User Know The Program Is Closing.
				MessageBox(NULL,"Program Will Now Close.","ERROR",MB_OK|MB_ICONSTOP);
				return false;									// Return false
			}
		}
	}

	if (fullscreen)												// Are We Still In Fullscreen Mode?
	{
		dwExStyle=WS_EX_APPWINDOW;								// Window Extended Style
		dwStyle=WS_POPUP;										// Windows Style
		ShowCursor(FALSE);										// Hide Mouse Pointer
		ix=iy=0;
	}
	else
	{
		dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;			// Window Extended Style
		dwStyle=WS_OVERLAPPEDWINDOW;							// Windows Style
	}

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);		// Adjust Window To True Requested Size

	// Create The Window
	if (!(glutarConfig.hWnd=CreateWindowEx(	
								dwExStyle,							// Extended Style For The Window
								"GlutarGLWin",						// Class Name
								title,								// Window Title
								dwStyle |							// Defined Window Style
								WS_CLIPSIBLINGS |					// Required Window Style
								WS_CLIPCHILDREN,					// Required Window Style
								ix, iy,								// Window Position
								WindowRect.right-WindowRect.left,	// Calculate Window Width
								WindowRect.bottom-WindowRect.top,	// Calculate Window Height
								NULL,								// No Parent Window
								NULL,								// No Menu
								glutarConfig.hInstance,				// Instance
								NULL)))								// Dont Pass Anything To WM_CREATE
	{
		KillGlutarWindow();								// Reset The Display
		MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;								// Return false
	}

	static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		bits,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		0,											// No Alpha Buffer
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)
		0,											// No Stencil Buffer
		//8,											// 8Bit Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};
	
	// Did We Get A Device Context?
	if (!(glutarConfig.hDC=GetDC(glutarConfig.hWnd)))
	{
		KillGlutarWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Device Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;								// Return false
	}

	// Did Windows Find A Matching Pixel Format?
	if (!(PixelFormat=ChoosePixelFormat(glutarConfig.hDC,&pfd)))
	{
		KillGlutarWindow();								// Reset The Display
		MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;								// Return false
	}

	// Are We Able To Set The Pixel Format?
	if(!SetPixelFormat(glutarConfig.hDC,PixelFormat,&pfd))
	{
		KillGlutarWindow();								// Reset The Display
		MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;								// Return false
	}

	// Are We Able To Get A Rendering Context?
	if (!(glutarConfig.hRC=wglCreateContext(glutarConfig.hDC)))
	{
		KillGlutarWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;								// Return false
	}

	// Try To Activate The Rendering Context
	if(!wglMakeCurrent(glutarConfig.hDC,glutarConfig.hRC))
	{
		KillGlutarWindow();								// Reset The Display
		MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;								// Return false
	}

	ShowWindow(glutarConfig.hWnd,SW_SHOW);			// Show The Window
	SetForegroundWindow(glutarConfig.hWnd);			// Slightly Higher Priority
	SetFocus(glutarConfig.hWnd);					// Sets Keyboard Focus To The Window
	
	return true;									// Success
}

int glutarMainLoop(void)
{
	MSG		msg;									// Windows Message Structure

	if (glutarConfig.reshapeFunc)
		glutarConfig.reshapeFunc(glutarConfig.win_width,glutarConfig.win_height);
	glutarConfig.displayFunc();
	active = true;

	while(!glutarConfig.done)						// Loop That Runs While done=FALSE
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))	// Is There A Message Waiting?
		{
			if (msg.message==WM_QUIT)				// Have We Received A Quit Message?
			{
				glutarConfig.done=true;				// If So done=TRUE
			}
			else									// If Not, Deal With Window Messages
			{
				TranslateMessage(&msg);				// Translate The Message
				DispatchMessage(&msg);				// Dispatch The Message
			}
		}
		else										// If There Are No Messages
		{
			if (active)								// Program Active?
			{
				if (glutarConfig.idleFunc)			// Idle function registered?
					glutarConfig.idleFunc();		// Allow idle processing
			}
		}
	}

	KillGlutarWindow();								// Kill The Window
	return (msg.wParam);							// Exit The Program
}

void glutarPostRedisplay(void)
{
	InvalidateRect (glutarConfig.hWnd, NULL, FALSE);
}

void glutarSwapBuffers(void)
{
	SwapBuffers(glutarConfig.hDC);
}

bool glutarChangeWindowSettings(char* title, int x, int y, int width, int height, int bits, bool fullscreen, int freq)
{
	KillGlutarWindow();

	glutarConfig.win_width = width;
	glutarConfig.win_height = height;
	glutarConfig.init_win_pos_x = x;
	glutarConfig.init_win_pos_y = y;
	glutarConfig.bitdepth = bits;
	glutarConfig.fullscreen = fullscreen;
	glutarConfig.displayfreq = freq;

	return glutarCreateWindow(title);
}

void glutarQuit(void)
{
	PostQuitMessage(0);
}