#pragma once

#ifndef MAX_PLAYERS
#define MAX_PLAYERS 8
#endif

struct WorldConfig
{
	// Acceleration of objects due to gravity
	float gravity;
	bool usingCubicSplineInterp;
	bool sound;
	float fov;
};


#define MAX_PROJECTILES 1000

#define SKY_FACE_TOP		0
#define SKY_FACE_BOTTOM	1
#define SKY_FACE_LEFT	2
#define SKY_FACE_RIGHT	3
#define SKY_FACE_FRONT	4
#define SKY_FACE_BACK	5

class WorldInformation {
	protected:
		static char* skyfilesuffix[2];
		static char skyBaseFileName[MAX_PATH];
		static rgb_image_type skyimage[2];
		static tex_object_2D  skytex[2];

		void DrawSkyBox();

	public:
		void StartTreeFire(int treeIdx);

		bool nightmode;

		float skyBoxLowerZ;

		bool ThisWorldIsTheServer;

		void SetDisplayLighting();
		void SetDisplayMode();
		WorldInformation()
		{	settings.usingCubicSplineInterp = false;
			ThisWorldIsTheServer = false;
			particleEngine.myworld = this;
			skyBoxLowerZ = -1;
			nightmode = false;
		};

		TankObject tank[MAX_PLAYERS];

		MapObject map;

		MobileModel eyepoint;
		FollowerDynamics eyedyn;
		vec3f eyeDirection;
		vec3f eyeTarget;

		vec4f lightPos;
		vec4f lightCol;
		vec4f lightAmb;

		WorldConfig settings;
		
		ProjectileInfo projectiles[MAX_PROJECTILES];
		ParticleEngine particleEngine;

		void update(double dtime);
		void LoadData();
		void ReleaseModels();
		void RegisterModels();
		void Draw();
		void Reset();
		bool HandleInput(InputEvent_type e);

		timet currentTime;		// Current time in ms
		timet dtime;				// Delta time from last time step in ms
};

//extern WorldInformation world;
