#pragma once

class GLFont
{
	private:
		GLYPHMETRICSFLOAT gmf[256];	// Storage For Information About Our Outline Font Characters
		GLYPHMETRICS      gmb[256];	// Storage For Information About Our Bitmap Font Characters
		GLuint baseDList;
		bool isvalid;
		bool isbitmap;
		GLfloat xscale, yscale, zscale;

		float lineHeight;
	public:
		GLFont(char* fname, char* filename=NULL, float depth=0.0, bool lineOnly=false, bool bitmapped=false);
		~GLFont();

		bool valid();
		void printLeft(const char *fmt, ...);
		void printCenter(const char *fmt, ...);
		void printRight(const char *fmt, ...);
		void printxyz(GLfloat x, GLfloat y, GLfloat z, const char *fmt, ...);
		void printxyzRight(GLfloat x, GLfloat y, GLfloat z, const char *fmt, ...);
		void printxyzCenter(GLfloat x, GLfloat y, GLfloat z, const char *fmt, ...);

		float getHeight();
		float getBaseHeight() { return lineHeight; };
		float getStrWidth(char *text);

		void setScale(GLfloat xs, GLfloat ys, GLfloat zs);
};